/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.tcresearchpatcher.extended;

import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.research.IScanThing;

public class ScanItemExtended
implements IScanThing {
    protected String research;
    protected ItemStack ref;
    protected boolean strict;
    @Nullable
    protected NBTTagCompound caps;

    public ScanItemExtended(String research, ItemStack stack) {
        this(research, stack, null, false);
    }

    public ScanItemExtended(String research, ItemStack stack, @Nullable NBTTagCompound capabilities, boolean strictMatching) {
        this.research = research;
        this.ref = stack;
        this.caps = capabilities;
        this.strict = strictMatching;
    }

    protected boolean tagsMatch(NBTBase tag1, NBTBase tag2) {
        if (this.strict) {
            return tag1.equals((Object)tag2);
        }
        if (tag1.func_74732_a() == tag2.func_74732_a()) {
            if (tag1 instanceof NBTTagCompound) {
                NBTTagCompound compound1 = (NBTTagCompound)tag1;
                NBTTagCompound compound2 = (NBTTagCompound)tag2;
                for (String k : compound1.func_150296_c()) {
                    if (compound2.func_150297_b(k, (int)compound1.func_150299_b(k)) && this.tagsMatch(compound1.func_74781_a(k), compound2.func_74781_a(k))) continue;
                    return false;
                }
                return true;
            }
            if (tag1 instanceof NBTTagList) {
                NBTTagList list1 = (NBTTagList)tag1;
                NBTTagList list2 = (NBTTagList)tag2;
                for (NBTBase find1 : list1) {
                    boolean found = false;
                    for (NBTBase find2 : list2) {
                        if (!find1.equals((Object)find2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
            return tag1.equals((Object)tag2);
        }
        return false;
    }

    protected boolean matches(ItemStack stack) {
        if (!OreDictionary.itemMatches((ItemStack)this.ref, (ItemStack)stack, (boolean)this.strict)) {
            return false;
        }
        if (!(!this.ref.func_77942_o() || stack.func_77942_o() && this.tagsMatch((NBTBase)this.ref.func_77978_p(), (NBTBase)stack.func_77978_p()))) {
            return false;
        }
        NBTTagCompound stackTag = stack.serializeNBT();
        boolean refCaps = this.caps != null;
        boolean stackCaps = stackTag.func_150297_b("ForgeCaps", 10);
        if (!refCaps && !stackCaps) {
            return true;
        }
        if (refCaps ^ stackCaps) {
            return false;
        }
        NBTTagCompound capsRef = this.caps.func_74737_b();
        NBTTagCompound capsStack = stackTag.func_74775_l("ForgeCaps");
        for (String key : capsStack.func_150296_c()) {
            if (capsRef.func_150297_b(key, (int)capsStack.func_150299_b(key))) continue;
            capsRef.func_74782_a(key, capsStack.func_74781_a(key));
        }
        NBTTagCompound refTag = this.ref.serializeNBT();
        refTag.func_74782_a("ForgeCaps", (NBTBase)capsRef);
        return new ItemStack(stackTag).areCapsCompatible(new ItemStack(refTag));
    }

    public boolean checkThing(EntityPlayer player, Object thing) {
        if (thing == null) {
            return false;
        }
        ItemStack stack = null;
        if (thing instanceof EntityItem) {
            stack = ((EntityItem)thing).func_92059_d();
        } else if (thing instanceof ItemStack) {
            stack = (ItemStack)thing;
        }
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        return this.matches(stack);
    }

    public String getResearchKey(EntityPlayer player, Object thing) {
        return this.research;
    }
}

