/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.tcresearchpatcher.json;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import thecodex6824.tcresearchpatcher.json.JsonSchemaException;

public class JsonUtils {
    public static Optional<JsonElement> tryGet(String key, JsonObject obj) {
        JsonElement e = obj.get(key);
        if (e == null) {
            return Optional.absent();
        }
        return Optional.of((Object)e);
    }

    public static JsonElement getOrThrow(String key, JsonObject obj) throws JsonSchemaException {
        JsonElement e = obj.get(key);
        if (e == null) {
            throw new JsonSchemaException("Key " + key + " is missing");
        }
        return e;
    }

    public static Optional<JsonPrimitive> tryGetPrimitive(String key, JsonObject obj) {
        JsonElement e = obj.get(key);
        if (e == null || !e.isJsonPrimitive()) {
            return Optional.absent();
        }
        return Optional.of((Object)e.getAsJsonPrimitive());
    }

    public static JsonPrimitive getPrimitiveOrThrow(String key, JsonObject obj) throws JsonSchemaException {
        JsonElement e = obj.get(key);
        if (e == null) {
            throw new JsonSchemaException("Key " + key + " is missing");
        }
        if (!e.isJsonPrimitive()) {
            throw new JsonSchemaException("Key " + key + " does not have a primitive value");
        }
        return e.getAsJsonPrimitive();
    }

    public static Optional<JsonArray> tryGetArray(String key, JsonObject obj) {
        JsonElement e = obj.get(key);
        if (e == null || !e.isJsonArray()) {
            return Optional.absent();
        }
        return Optional.of((Object)e.getAsJsonArray());
    }

    public static JsonArray getArrayOrThrow(String key, JsonObject obj) throws JsonSchemaException {
        JsonElement e = obj.get(key);
        if (e == null) {
            throw new JsonSchemaException("Key " + key + " is missing");
        }
        if (!e.isJsonArray()) {
            throw new JsonSchemaException("Key " + key + " does not have an array value");
        }
        return e.getAsJsonArray();
    }

    public static Optional<JsonObject> tryGetObject(String key, JsonObject obj) {
        JsonElement e = obj.get(key);
        if (e == null || !e.isJsonObject()) {
            return Optional.absent();
        }
        return Optional.of((Object)e.getAsJsonObject());
    }

    public static JsonObject getObjectOrThrow(String key, JsonObject obj) throws JsonSchemaException {
        JsonElement e = obj.get(key);
        if (e == null) {
            throw new JsonSchemaException("Key " + key + " is missing");
        }
        if (!e.isJsonObject()) {
            throw new JsonSchemaException("Key " + key + " does not have an object value");
        }
        return e.getAsJsonObject();
    }

    public static List<JsonObject> getObjectOrArrayContainedObjects(JsonElement element) throws JsonSchemaException {
        return JsonUtils.getObjectOrArrayContainedObjects(element, false);
    }

    public static List<JsonObject> getObjectOrArrayContainedObjects(JsonElement element, boolean allowSkipInvalid) throws JsonSchemaException {
        if (element.isJsonPrimitive()) {
            throw new JsonSchemaException("Value must be an object or array");
        }
        if (element.isJsonObject()) {
            return Lists.newArrayList((Object[])new JsonObject[]{element.getAsJsonObject()});
        }
        ArrayList<JsonObject> objects = new ArrayList<JsonObject>();
        for (JsonElement e : element.getAsJsonArray()) {
            if (e.isJsonObject()) {
                objects.add(e.getAsJsonObject());
                continue;
            }
            if (allowSkipInvalid) continue;
            throw new JsonSchemaException("Array must only contain objects");
        }
        return objects;
    }
}

