/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class ItemStackListFactory {
    private final ISubtypeRegistry subtypeRegistry;

    public ItemStackListFactory(ISubtypeRegistry subtypeRegistry) {
        this.subtypeRegistry = subtypeRegistry;
    }

    public List<ItemStack> create(StackHelper stackHelper) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<String> itemNameSet = new HashSet<String>();
        NonNullList creativeTabItemStacks = NonNullList.func_191196_a();
        for (CreativeTabs creativeTab : CreativeTabs.field_78032_a) {
            if (creativeTab == CreativeTabs.field_192395_m) continue;
            try {
                creativeTab.func_78018_a(creativeTabItemStacks);
            }
            catch (LinkageError | RuntimeException e) {
                Log.get().error("Creative tab crashed while getting items. Some items from this tab will be missing from the item list. {}", (Object)creativeTab, (Object)e);
                creativeTabItemStacks.clear();
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack.func_190926_b()) {
                    Log.get().error("Found an empty itemStack from creative tab: {}", (Object)creativeTab);
                    continue;
                }
                if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                    String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
                    Log.get().error("Found an itemStack with wildcard metadata from creative tab: {}. {}", (Object)creativeTab, (Object)itemStackInfo);
                    continue;
                }
                this.addItemStack(stackHelper, itemStack, itemList, itemNameSet);
            }
            creativeTabItemStacks.clear();
        }
        for (Block block : ForgeRegistries.BLOCKS) {
            this.addBlockAndSubBlocks(stackHelper, block, itemList, itemNameSet);
        }
        for (Item item : ForgeRegistries.ITEMS) {
            this.addItemAndSubItems(stackHelper, item, itemList, itemNameSet);
        }
        return itemList;
    }

    private void addItemAndSubItems(StackHelper stackHelper, @Nullable Item item, List<ItemStack> itemList, Set<String> itemNameSet) {
        if (item == null || item == Items.field_190931_a) {
            return;
        }
        NonNullList items = NonNullList.func_191196_a();
        stackHelper.addSubtypesToList((List<ItemStack>)items, item);
        for (ItemStack stack : items) {
            this.addItemStack(stackHelper, stack, itemList, itemNameSet);
        }
    }

    private void addBlockAndSubBlocks(StackHelper stackHelper, @Nullable Block block, List<ItemStack> itemList, Set<String> itemNameSet) {
        if (block == null) {
            return;
        }
        Item item = Item.func_150898_a((Block)block);
        if (item == Items.field_190931_a) {
            return;
        }
        NonNullList subBlocks = NonNullList.func_191196_a();
        for (CreativeTabs itemTab : item.getCreativeTabs()) {
            try {
                block.func_149666_a(itemTab, subBlocks);
            }
            catch (LinkageError | RuntimeException e) {
                String itemStackInfo = ErrorUtil.getItemStackInfo(new ItemStack(item));
                Log.get().error("Failed to getSubBlocks {}", (Object)itemStackInfo, (Object)e);
                subBlocks.clear();
            }
            for (ItemStack subBlock : subBlocks) {
                if (subBlock == null) {
                    Log.get().error("Found null subBlock of {}", (Object)block);
                    continue;
                }
                if (subBlock.func_190926_b()) {
                    Log.get().error("Found empty subBlock of {}", (Object)block);
                    continue;
                }
                this.addItemStack(stackHelper, subBlock, itemList, itemNameSet);
            }
            subBlocks.clear();
        }
    }

    private void addItemStack(StackHelper stackHelper, ItemStack stack, List<ItemStack> itemList, Set<String> itemNameSet) {
        String itemKey;
        try {
            this.addFallbackSubtypeInterpreter(stack);
            itemKey = stackHelper.getUniqueIdentifierForStack(stack, StackHelper.UidMode.FULL);
        }
        catch (LinkageError | RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            Log.get().error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
            return;
        }
        if (!itemNameSet.contains(itemKey)) {
            itemNameSet.add(itemKey);
            itemList.add(stack);
        }
    }

    private void addFallbackSubtypeInterpreter(ItemStack itemStack) {
        if (!this.subtypeRegistry.hasSubtypeInterpreter(itemStack)) {
            try {
                String info = FluidSubtypeInterpreter.INSTANCE.apply(itemStack);
                if (!"".equals(info)) {
                    this.subtypeRegistry.registerSubtypeInterpreter(itemStack.func_77973_b(), FluidSubtypeInterpreter.INSTANCE);
                }
            }
            catch (LinkageError | RuntimeException e) {
                String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
                Log.get().error("Failed to apply FluidSubtypeInterpreter to ItemStack: {}", (Object)itemStackInfo, (Object)e);
            }
        }
    }

    private static class FluidSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        public static final FluidSubtypeInterpreter INSTANCE = new FluidSubtypeInterpreter();

        private FluidSubtypeInterpreter() {
        }

        @Override
        public String apply(ItemStack itemStack) {
            IFluidHandler capability;
            if (itemStack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (capability = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
                IFluidTankProperties[] tankPropertiesList = capability.getTankProperties();
                StringBuilder info = new StringBuilder();
                for (IFluidTankProperties tankProperties : tankPropertiesList) {
                    String contentsName = FluidSubtypeInterpreter.getContentsName(tankProperties);
                    if (contentsName != null) {
                        info.append(contentsName).append(";");
                        continue;
                    }
                    info.append("empty").append(";");
                }
                if (info.length() > 0) {
                    if (itemStack.func_77981_g()) {
                        info.append("m=").append(itemStack.func_77960_j());
                    }
                    return info.toString();
                }
            }
            return "";
        }

        @Nullable
        private static String getContentsName(IFluidTankProperties fluidTankProperties) {
            Fluid fluid;
            FluidStack contents = fluidTankProperties.getContents();
            if (contents != null && (fluid = contents.getFluid()) != null) {
                return fluid.getName();
            }
            return null;
        }
    }
}

