/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.IModPlugin;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.ServerInfo;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.textures.JeiTextureMap;
import mezz.jei.gui.textures.Textures;
import mezz.jei.network.PacketHandlerClient;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.plugins.jei.JEIInternalPlugin;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.startup.AnnotatedInstanceUtil;
import mezz.jei.startup.JeiStarter;
import mezz.jei.startup.PlayerJoinedWorldEvent;
import mezz.jei.startup.ProxyCommon;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProxyCommonClient
extends ProxyCommon {
    private List<IModPlugin> plugins = new ArrayList<IModPlugin>();
    private final JeiStarter starter = new JeiStarter();
    private final JeiTextureMap textureMap = new JeiTextureMap("textures");
    @Nullable
    private Textures textures;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        IModPlugin jeiInternalPlugin;
        PacketHandlerClient packetHandler = new PacketHandlerClient();
        this.channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("jei");
        this.channel.register((Object)packetHandler);
        Config.preInit(event);
        ASMDataTable asmDataTable = event.getAsmData();
        this.plugins = AnnotatedInstanceUtil.getModPlugins(asmDataTable);
        IModPlugin vanillaPlugin = this.getVanillaPlugin(this.plugins);
        if (vanillaPlugin != null) {
            this.plugins.remove(vanillaPlugin);
            this.plugins.add(0, vanillaPlugin);
        }
        if ((jeiInternalPlugin = this.getJeiInternalPlugin(this.plugins)) != null) {
            this.plugins.remove(jeiInternalPlugin);
            this.plugins.add(jeiInternalPlugin);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nullable
    private IModPlugin getVanillaPlugin(List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof VanillaPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Nullable
    private IModPlugin getJeiInternalPlugin(List<IModPlugin> modPlugins) {
        for (IModPlugin modPlugin : modPlugins) {
            if (!(modPlugin instanceof JEIInternalPlugin)) continue;
            return modPlugin;
        }
        return null;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        KeyBindings.init();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71446_o.func_110580_a(this.textureMap.getLocation(), (ITickableTextureObject)this.textureMap);
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IReloadableResourceManager reloadableResourceManager = (IReloadableResourceManager)minecraft.func_110442_L();
        reloadableResourceManager.func_110542_a(resourceManager -> {
            if (this.starter.hasStarted()) {
                if (Config.isDebugModeEnabled()) {
                    Log.get().info("Reloading HEI ingredient filter.", (Throwable)new RuntimeException("Stack trace for debugging"));
                } else {
                    Log.get().info("Reloading HEI ingredient filter.");
                }
                Config.needToRebuildSearchTree = true;
                ProxyCommonClient.reloadItemList();
            }
            Translator.invalidateLocale();
        });
        Preconditions.checkNotNull((Object)this.textures);
        this.starter.start(this.plugins, this.textures);
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal() && !event.getConnectionType().equals("MODDED")) {
            ServerInfo.onConnectedToServer(false);
        }
        NetworkManager networkManager = event.getManager();
        Config.syncWorldConfig(networkManager);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerJoinedWorldEvent());
        Internal.getIngredientFilter().block();
    }

    private static void reloadItemList() {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime != null) {
            IngredientListOverlay ingredientListOverlay = runtime.getIngredientListOverlay();
            ingredientListOverlay.rebuildItemFilter();
            ingredientListOverlay.invalidateBuffer();
        }
    }

    @Override
    public void sendPacketToServer(PacketJei packet) {
        NetHandlerPlayClient netHandler = FMLClientHandler.instance().getClient().func_147114_u();
        if (netHandler != null && ServerInfo.isJeiOnServer()) {
            netHandler.func_147297_a((Packet)packet.getPacket());
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("jei".equals(eventArgs.getModID())) {
            if (Config.syncAllConfig()) {
                ProxyCommonClient.reloadItemList();
            }
        } else if (this.starter.hasStarted()) {
            Config.checkForModNameFormatOverride();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        try {
            Config.saveFilterText();
        }
        catch (RuntimeException e) {
            Log.get().error("Failed to save filter text.", (Throwable)e);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        this.textures = new Textures(this.textureMap);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isCreative() {
        return Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_();
    }
}

