/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.asmc.sounds;

import astrotibs.asmc.capabilities.playerarmortracker.IPlayerArmorTracker;
import astrotibs.asmc.capabilities.playerarmortracker.PlayerArmorTracker;
import astrotibs.asmc.capabilities.playerarmortracker.PlayerArmorTrackerProvider;
import astrotibs.asmc.config.GeneralConfig;
import astrotibs.asmc.proxy.ClientProxy;
import astrotibs.asmc.sounds.SoundEventsASMC;
import astrotibs.asmc.sounds.SoundRegistryASMC;
import astrotibs.asmc.utility.LogHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SoundEventHandler {
    private static double enderEyeSoundRadius = 18.0;
    static final int everyNblocks = 100;
    static final int furnaceSoundRadius = 15;
    static final int totalBlocks = 29791;
    static final int numPosToCheck = 298;
    private static int currPage = -1;
    private static float beaconSoundRadius = 8.0f;
    private static float beaconRadiusSqrd = beaconSoundRadius * beaconSoundRadius;
    private static int xToScan = 0;
    private static int yToScan = 0;
    private static int zToScan = 0;
    private static HashMap<List<Integer>, Block> beaconmap;

    @SubscribeEvent
    public void onRegisterSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        SoundRegistryASMC.INSTANCE.init();
        event.getRegistry().registerAll((IForgeRegistryEntry[])SoundRegistryASMC.INSTANCE.getSounds().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 40L == 0L && GeneralConfig.beaconSounds) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            for (int xScan = MathHelper.func_76143_f((double)(player.field_70165_t - (double)beaconSoundRadius)); xScan <= MathHelper.func_76128_c((double)(player.field_70165_t + (double)beaconSoundRadius)); ++xScan) {
                double yzCircleDist = (double)xScan - player.field_70165_t;
                for (int yScan = MathHelper.func_76143_f((double)(player.field_70163_u - (double)MathHelper.func_76133_a((double)((double)beaconRadiusSqrd - yzCircleDist * yzCircleDist)))); yScan <= MathHelper.func_76128_c((double)(player.field_70163_u + (double)MathHelper.func_76133_a((double)((double)beaconRadiusSqrd - yzCircleDist * yzCircleDist)))); ++yScan) {
                    double zSliceDist = (double)yScan - player.field_70163_u;
                    for (int zScan = MathHelper.func_76143_f((double)(player.field_70161_v - (double)MathHelper.func_76133_a((double)((double)beaconRadiusSqrd - yzCircleDist * yzCircleDist - zSliceDist * zSliceDist)))); zScan <= MathHelper.func_76128_c((double)(player.field_70161_v + (double)MathHelper.func_76133_a((double)((double)beaconRadiusSqrd - yzCircleDist * yzCircleDist - zSliceDist * zSliceDist)))); ++zScan) {
                        TileEntity tileentity = world.func_175625_s(new BlockPos(xScan, yScan, zScan));
                        if (tileentity == null || !(tileentity instanceof TileEntityBeacon)) continue;
                        TileEntityBeacon teBeacon = (TileEntityBeacon)tileentity;
                        boolean beaconThinksItIsOn = teBeacon.func_174887_a_(0) > 0;
                        boolean beaconIsOnBruteFrc = false;
                        int j = 1;
                        int yBaseScan = teBeacon.func_174877_v().func_177956_o() - j;
                        boolean flag = true;
                        if (yBaseScan < 0) {
                            flag = false;
                        }
                        block3: for (int xBaseScan = teBeacon.func_174877_v().func_177958_n() - j; xBaseScan <= teBeacon.func_174877_v().func_177958_n() + j && flag; ++xBaseScan) {
                            for (int zBaseScan = teBeacon.func_174877_v().func_177952_p() - j; zBaseScan <= teBeacon.func_174877_v().func_177952_p() + j; ++zBaseScan) {
                                Block block = world.func_180495_p(new BlockPos(xBaseScan, yBaseScan, zBaseScan)).func_177230_c();
                                if (block.isBeaconBase((IBlockAccess)world, new BlockPos(xBaseScan, yBaseScan, zBaseScan), teBeacon.func_174877_v())) continue;
                                flag = false;
                                continue block3;
                            }
                        }
                        if (flag) {
                            beaconIsOnBruteFrc = true;
                        }
                        if (beaconThinksItIsOn) {
                            if (beaconIsOnBruteFrc) {
                                ClientProxy.handleBeaconSound(teBeacon);
                                continue;
                            }
                            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() % 80L != 0L) continue;
                            world.func_184134_a((double)xScan, (double)yScan, (double)zScan, SoundEventsASMC.BLOCK_BEACON_DEACTIVATE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                            continue;
                        }
                        if (!beaconIsOnBruteFrc || Minecraft.func_71410_x().field_71441_e.func_82737_E() % 80L != 0L) continue;
                        world.func_184134_a((double)xScan, (double)yScan, (double)zScan, SoundEventsASMC.BLOCK_BEACON_ACTIVATE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                    }
                }
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            if (currPage != -1) {
                currPage = -1;
            }
        }
    }

    @SubscribeEvent
    public void onNoteBlock(NoteBlockEvent.Play event) {
        if (!event.getWorld().field_72995_K) {
            BlockPos pos_at_sound = event.getPos();
            World world = event.getWorld();
            NoteBlockEvent.Instrument instrument = event.getInstrument();
            int note = event.getVanillaNoteId();
            if (instrument == NoteBlockEvent.Instrument.PIANO || instrument == NoteBlockEvent.Instrument.SNARE && world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150425_aM || instrument == NoteBlockEvent.Instrument.CLICKS && world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150426_aN || instrument == NoteBlockEvent.Instrument.BASSDRUM && (world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_189880_di || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c().getClass().toString().substring(6).toLowerCase().contains("boneblock") || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c().getClass().toString().substring(6).toLowerCase().contains("blockbone") || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c().getClass().toString().substring(6).toLowerCase().contains("blockbopbone")) && GeneralConfig.boneblockSounds && GeneralConfig.noteBlockSounds) {
                SoundEvent instrumentToPlay = null;
                IBlockState blockStateBeneath = world.func_180495_p(pos_at_sound.func_177977_b());
                Block blockBeneath = blockStateBeneath.func_177230_c();
                if (blockBeneath == Blocks.field_150425_aM) {
                    instrumentToPlay = SoundEventsASMC.NOTE_NOTEBLOCK_COWBELL;
                } else if (blockBeneath == Blocks.field_150407_cf) {
                    instrumentToPlay = SoundEventsASMC.NOTE_NOTEBLOCK_BANJO;
                } else if (blockBeneath == Blocks.field_150475_bE) {
                    instrumentToPlay = SoundEventsASMC.NOTE_NOTEBLOCK_BIT;
                } else if (blockBeneath == Blocks.field_150423_aK) {
                    instrumentToPlay = SoundEventsASMC.NOTE_NOTEBLOCK_DIDGERIDOO;
                } else if (blockBeneath == Blocks.field_150339_S) {
                    instrumentToPlay = SoundEventsASMC.NOTE_NOTEBLOCK_IRONXYLOPHONE;
                } else if (blockBeneath == Blocks.field_150426_aN) {
                    instrumentToPlay = SoundEvents.field_189107_dL;
                }
                if (instrumentToPlay != null) {
                    world.func_184133_a((EntityPlayer)null, pos_at_sound, instrumentToPlay, SoundCategory.RECORDS, blockBeneath == Blocks.field_150339_S ? 1.0f : 3.0f, (float)Math.pow(2.0, (double)(note - 12) / 12.0));
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlaySound(PlaySoundEvent event) {
        float soundX = event.getSound().func_147649_g();
        float soundY = event.getSound().func_147654_h();
        float soundZ = event.getSound().func_147651_i();
        if (GeneralConfig.debugMessages && Minecraft.func_71410_x().field_71441_e != null) {
            ISound sound = event.getSound();
            BlockPos sound_blockpos = new BlockPos(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)soundY), MathHelper.func_76141_d((float)soundZ));
            WorldClient sound_world = Minecraft.func_71410_x().field_71441_e;
            IBlockState sound_blockstate = sound_world.func_180495_p(sound_blockpos);
            int sound_block_meta = sound_blockstate.func_177230_c().func_176201_c(sound_blockstate);
            LogHelper.info(sound.func_147650_b().func_110624_b() + ":" + sound.func_147650_b().func_110623_a().toString() + ", at block " + sound_blockstate.func_177230_c() + " with meta " + sound_block_meta + " at " + soundX + " " + soundY + " " + soundZ);
        }
        if (event.getName().equals("entity.cow.milk") && GeneralConfig.mooshroommilkingSounds && event.getSound().func_147650_b().func_110624_b().equals("minecraft")) {
            SoundManager sndManager_reflected = (SoundManager)ReflectionHelper.getPrivateValue(SoundHandler.class, (Object)Minecraft.func_71410_x().func_147118_V(), (String[])new String[]{"field_147694_f", "sndManager"});
            Map playingSounds_reflected = (Map)ReflectionHelper.getPrivateValue(SoundManager.class, (Object)sndManager_reflected, (String[])new String[]{"field_148629_h", "playingSounds"});
            Iterator itr = playingSounds_reflected.keySet().iterator();
            while (itr.hasNext()) {
                PositionedSound positionedSound;
                try {
                    positionedSound = (PositionedSound)playingSounds_reflected.get(itr.next());
                }
                catch (Exception e) {
                    continue;
                }
                ResourceLocation resourceLocation_reflected = (ResourceLocation)ReflectionHelper.getPrivateValue(PositionedSound.class, (Object)positionedSound, (String[])new String[]{"field_147664_a", "positionedSoundLocation"});
                if (!resourceLocation_reflected.func_110624_b().equals("asmc") || (!event.getName().equals("entity.player.hurt") || !resourceLocation_reflected.func_110623_a().equals("entity.player.hurt_drown") && !resourceLocation_reflected.func_110623_a().equals("entity.player.hurt_on_fire")) && (!event.getName().equals("entity.bobber.throw") || !resourceLocation_reflected.func_110623_a().equals("entity.fishing_bobber.throw")) || !((soundX - positionedSound.func_147649_g()) * (soundX - positionedSound.func_147649_g()) + (soundY - positionedSound.func_147654_h()) * (soundY - positionedSound.func_147654_h()) + (soundZ - positionedSound.func_147651_i()) * (soundZ - positionedSound.func_147651_i()) <= 1.0f)) continue;
                event.setResultSound(null);
                return;
            }
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiScreenBook && event.getName().equals("ui.button.click") && GeneralConfig.bookpageSounds && Minecraft.func_71410_x().field_71462_r instanceof GuiScreenBook) {
            GuiScreenBook gui = (GuiScreenBook)Minecraft.func_71410_x().field_71462_r;
            int currPage_reflected = (Integer)ReflectionHelper.getPrivateValue(GuiScreenBook.class, (Object)gui, (String[])new String[]{"field_146484_x", "currPage"});
            if (currPage_reflected != currPage) {
                currPage = currPage_reflected;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                player.func_184185_a(SoundEventsASMC.ITEM_BOOK_PAGETURN, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                event.setResultSound(null);
                return;
            }
        }
        if (!Minecraft.func_71410_x().func_147113_T() && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            BlockPos pos_at_sound = new BlockPos(MathHelper.func_76141_d((float)soundX), MathHelper.func_76141_d((float)(soundY - 0.01f)), MathHelper.func_76141_d((float)soundZ));
            IBlockState blockstate_at_sound = world.func_180495_p(pos_at_sound);
            Block block_at_sound = blockstate_at_sound.func_177230_c();
            SoundType soundtype = block_at_sound.func_185467_w();
            if (event.getSound().func_147650_b().func_110624_b().equals("minecraft")) {
                String eventName;
                if ((event.getName().equals("entity.player.splash") || event.getName().equals("entity.player.swim")) && GeneralConfig.swimSounds_modern) {
                    float playerBoxRange = 0.25f;
                    List playerList = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)(soundX - playerBoxRange), (double)(soundY - playerBoxRange), (double)(soundZ - playerBoxRange), (double)(soundX + playerBoxRange), (double)(soundY + playerBoxRange), (double)(soundZ + playerBoxRange)));
                    for (EntityPlayer playerselected : playerList) {
                        float resetHeight_f = MathHelper.func_76133_a((double)(playerselected.field_70159_w * playerselected.field_70159_w * (double)0.2f + playerselected.field_70181_x * playerselected.field_70181_x + playerselected.field_70179_y * playerselected.field_70179_y * (double)0.2f)) * 0.35f;
                        float doWaterSplashEffect_f1 = resetHeight_f / 0.35f * (!playerselected.func_184207_aI() ? 0.2f : 0.9f);
                        if (resetHeight_f > 1.0f) {
                            resetHeight_f = 1.0f;
                        }
                        if (doWaterSplashEffect_f1 > 1.0f) {
                            doWaterSplashEffect_f1 = 1.0f;
                        }
                        if (event.getName().equals("entity.player.swim")) {
                            world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, GeneralConfig.swimSounds_legacy ? SoundEventsASMC.ENTITY_PLAYER_SWIM_FULL : SoundEventsASMC.ENTITY_PLAYER_SWIM, SoundCategory.PLAYERS, resetHeight_f, 1.0f + (playerselected.field_70170_p.field_73012_v.nextFloat() - playerselected.field_70170_p.field_73012_v.nextFloat()) * 0.4f, false);
                            event.setResultSound(null);
                            return;
                        }
                        if (!event.getName().equals("entity.player.splash") || !((double)doWaterSplashEffect_f1 >= 0.25)) continue;
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.ENTITY_PLAYER_SPLASH_HIGHSPEED, SoundCategory.PLAYERS, doWaterSplashEffect_f1, 1.0f + (playerselected.field_70170_p.field_73012_v.nextFloat() - playerselected.field_70170_p.field_73012_v.nextFloat()) * 0.4f, false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if (block_at_sound == Blocks.field_150323_B && GeneralConfig.noteBlockSounds && ((eventName = event.getName()).equals("block.note.harp") && (world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150339_S || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150423_aK || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150475_bE || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150407_cf) || eventName.equals("block.note.snare") && world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150425_aM || eventName.equals("block.note.hat") && world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150426_aN || eventName.equals("block.note.basedrum") && (world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_189880_di || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c().getClass().toString().substring(6).toLowerCase().contains("boneblock") || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c().getClass().toString().substring(6).toLowerCase().contains("blockbone") || world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c().getClass().toString().substring(6).toLowerCase().contains("blockbopbone")) && GeneralConfig.boneblockSounds)) {
                    event.setResultSound(null);
                    return;
                }
                if ((block_at_sound instanceof BlockLilyPad || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("waterlily") || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("lilypad")) && world.func_180495_p(pos_at_sound.func_177977_b()).func_177230_c() == Blocks.field_150432_aD && GeneralConfig.lilypadSounds && event.getName().equals("block.grass.place")) {
                    event.setResultSound(null);
                    return;
                }
                if (block_at_sound instanceof BlockNetherrack && GeneralConfig.netherrackSounds) {
                    if (event.getName().equals("block.stone.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERRACK_BREAK, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.fall")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERRACK_FALL, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.hit")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERRACK_HIT, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.place")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERRACK_PLACE, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.step")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERRACK_STEP, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b(), false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if (block_at_sound == Blocks.field_150449_bY && GeneralConfig.netherquartzoreSounds) {
                    if (event.getName().equals("block.stone.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERORE_BREAK, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.fall")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERORE_FALL, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.hit")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERORE_HIT, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.place")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERORE_PLACE, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.step")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERORE_STEP, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b(), false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if ((block_at_sound == Blocks.field_150385_bj || block_at_sound == Blocks.field_150386_bk || block_at_sound == Blocks.field_150387_bl || block_at_sound == Blocks.field_189879_dh || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("rednetherbrick") || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("red_nether_brick") || block_at_sound instanceof BlockStoneSlab && (BlockStoneSlab.EnumType)blockstate_at_sound.func_177229_b((IProperty)BlockStoneSlab.field_176556_M) == BlockStoneSlab.EnumType.NETHERBRICK) && GeneralConfig.netherbrickSounds) {
                    if (event.getName().equals("block.stone.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERBRICKS_BREAK, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f * 0.8f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.fall")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERBRICKS_FALL, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.hit")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERBRICKS_HIT, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.place")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERBRICKS_PLACE, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f * 0.8f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.step")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERBRICKS_STEP, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b(), false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if (block_at_sound.getClass().toString().substring(6).toLowerCase().contains("basalt") && GeneralConfig.basaltblockSounds) {
                    if (event.getName().equals("block.stone.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BASALT_BREAK, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.fall")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BASALT_FALL, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.hit")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BASALT_HIT, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.place")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BASALT_PLACE, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.step")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BASALT_STEP, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b(), false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if ((world.func_180495_p(pos_at_sound).func_177230_c() == Blocks.field_189880_di || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("blockbone") || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("boneblock") || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("blockbopbone")) && GeneralConfig.boneblockSounds) {
                    if (event.getName().equals("block.stone.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BONEBLOCK_BREAK, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.fall")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BONEBLOCK_FALL, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.hit")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BONEBLOCK_HIT, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.place")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BONEBLOCK_PLACE, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.stone.step")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_BONEBLOCK_STEP, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b(), false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if ((world.func_180495_p(pos_at_sound).func_177230_c() == Blocks.field_189878_dg || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("blocknetherwart") || block_at_sound.getClass().toString().substring(6).toLowerCase().contains("netherwartblock")) && GeneralConfig.netherwartblockSounds) {
                    if (event.getName().equals("block.wood.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_WARTBLOCK_BREAK, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.wood.fall")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_WARTBLOCK_FALL, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.wood.hit")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_WARTBLOCK_HIT, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.wood.place")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_WARTBLOCK_PLACE, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.wood.step")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_WARTBLOCK_STEP, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b(), false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if (block_at_sound instanceof BlockSoulSand && GeneralConfig.soulsandSounds) {
                    if (event.getName().equals("block.sand.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_SOULSAND_BREAK, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.sand.fall")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_SOULSAND_FALL, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.sand.hit")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_SOULSAND_HIT, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 8.0f, soundtype.func_185847_b() * 0.5f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.sand.place")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_SOULSAND_PLACE, SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.sand.step")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_SOULSAND_STEP, SoundCategory.BLOCKS, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b(), false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if (event.getName().equals("ambient.cave") && GeneralConfig.moreCaveSounds) {
                    world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.AMBIENT_CAVE, SoundCategory.AMBIENT, 0.7f, 0.8f + world.field_73012_v.nextFloat() * 0.2f, false);
                    event.setResultSound(null);
                    return;
                }
                if (GeneralConfig.cropbreakingSounds) {
                    if (block_at_sound instanceof BlockCrops && event.getName().equals("block.grass.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_CROP_BREAK, SoundCategory.BLOCKS, 0.9f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (block_at_sound instanceof BlockNetherWart && event.getName().equals("block.stone.break")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, SoundEventsASMC.BLOCK_NETHERWART_BREAK, SoundCategory.BLOCKS, 0.9f, 0.9f, false);
                        event.setResultSound(null);
                        return;
                    }
                }
                if (block_at_sound instanceof BlockDoor && blockstate_at_sound.func_185904_a() == Material.field_151575_d && (GeneralConfig.woodendoorSounds_legacy || GeneralConfig.woodendoorSounds_modern)) {
                    if (event.getName().equals("block.wooden_door.open")) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, GeneralConfig.woodendoorSounds_legacy ? SoundEventsASMC.BLOCK_WOODENDOOR_OPEN_LEGACY : SoundEventsASMC.BLOCK_WOODENDOOR_OPEN, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                        event.setResultSound(null);
                        return;
                    }
                    if (event.getName().equals("block.wooden_door.close") && (GeneralConfig.woodendoorSounds_legacy || GeneralConfig.woodendoorSounds_modern)) {
                        world.func_184134_a((double)soundX, (double)soundY, (double)soundZ, GeneralConfig.woodendoorSounds_legacy ? (GeneralConfig.woodendoorSounds_modern ? SoundEventsASMC.BLOCK_WOODENDOOR_CLOSE_LEGACY_MODERN : SoundEventsASMC.BLOCK_WOODENDOOR_CLOSE_LEGACY) : (GeneralConfig.woodendoorSounds_modern ? SoundEventsASMC.BLOCK_WOODENDOOR_CLOSE_MODERN : SoundEvents.field_187873_gM), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                        event.setResultSound(null);
                        return;
                    }
                }
            }
        }
    }

    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntity()) != null && player.field_70170_p != null && GeneralConfig.armorequipSounds) {
            ItemStack playerBoots = player.func_184582_a(EntityEquipmentSlot.FEET);
            ItemStack playerLeggings = player.func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack playerChestplate = player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack playerHelmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
            IPlayerArmorTracker ipat = (IPlayerArmorTracker)player.getCapability(PlayerArmorTrackerProvider.PLAYER_ARMOR_TRACKER, null);
            ItemStack storedBoots = ipat.getBoots() == null ? null : new ItemStack(ipat.getBoots());
            ItemStack storedLeggings = ipat.getLeggings() == null ? null : new ItemStack(ipat.getLeggings());
            ItemStack storedChestplate = ipat.getChestplate() == null ? null : new ItemStack(ipat.getChestplate());
            ItemStack storedHelmet = ipat.getHelmet() == null ? null : new ItemStack(ipat.getHelmet());
            SoundEvent itemEquippedSound = null;
            if (playerBoots != null && !playerBoots.func_190926_b() && (storedBoots == null || storedBoots.func_190926_b() || !storedBoots.func_190926_b() && (!playerBoots.func_77973_b().equals(storedBoots.func_77973_b()) || playerBoots.func_77978_p() == null && storedBoots.func_77978_p() != null || playerBoots.func_77978_p() != null && !playerBoots.func_77978_p().equals((Object)storedBoots.func_77978_p())))) {
                itemEquippedSound = playerBoots.func_77973_b() == Items.field_151029_X ? SoundEvents.field_187713_n : (playerBoots.func_77973_b() == Items.field_151175_af ? SoundEvents.field_187716_o : (playerBoots.func_77973_b() == Items.field_151151_aj ? SoundEvents.field_187722_q : (playerBoots.func_77973_b() == Items.field_151167_ab ? SoundEvents.field_187725_r : (playerBoots.func_77973_b() == Items.field_151021_T ? SoundEvents.field_187728_s : SoundEvents.field_187719_p))));
            }
            if (!SoundEventHandler.areItemStacksEqual(playerBoots, storedBoots)) {
                ipat.setBoots(PlayerArmorTracker.saveItemStackToNBT(playerBoots));
            }
            if (playerLeggings != null && !playerLeggings.func_190926_b() && (storedLeggings == null || storedLeggings.func_190926_b() || !storedLeggings.func_190926_b() && (!playerLeggings.func_77973_b().equals(storedLeggings.func_77973_b()) || playerLeggings.func_77978_p() == null && storedLeggings.func_77978_p() != null || playerLeggings.func_77978_p() != null && !playerLeggings.func_77978_p().equals((Object)storedLeggings.func_77978_p())))) {
                itemEquippedSound = playerLeggings.func_77973_b() == Items.field_151022_W ? SoundEvents.field_187713_n : (playerLeggings.func_77973_b() == Items.field_151173_ae ? SoundEvents.field_187716_o : (playerLeggings.func_77973_b() == Items.field_151149_ai ? SoundEvents.field_187722_q : (playerLeggings.func_77973_b() == Items.field_151165_aa ? SoundEvents.field_187725_r : (playerLeggings.func_77973_b() == Items.field_151026_S ? SoundEvents.field_187728_s : SoundEvents.field_187719_p))));
            }
            if (!SoundEventHandler.areItemStacksEqual(playerLeggings, storedLeggings)) {
                ipat.setLeggings(PlayerArmorTracker.saveItemStackToNBT(playerLeggings));
            }
            if (playerChestplate != null && !playerChestplate.func_190926_b() && (storedChestplate == null || storedChestplate.func_190926_b() || !storedChestplate.func_190926_b() && (!playerChestplate.func_77973_b().equals(storedChestplate.func_77973_b()) || playerChestplate.func_77978_p() == null && storedChestplate.func_77978_p() != null || playerChestplate.func_77978_p() != null && !playerChestplate.func_77978_p().equals((Object)storedChestplate.func_77978_p())))) {
                itemEquippedSound = playerChestplate.func_77973_b() == Items.field_151023_V ? SoundEvents.field_187713_n : (playerChestplate.func_77973_b() == Items.field_151163_ad ? SoundEvents.field_187716_o : (playerChestplate.func_77973_b() == Items.field_151171_ah ? SoundEvents.field_187722_q : (playerChestplate.func_77973_b() == Items.field_151030_Z ? SoundEvents.field_187725_r : (playerChestplate.func_77973_b() == Items.field_151027_R ? SoundEvents.field_187728_s : (playerChestplate.func_77973_b() == Items.field_185160_cR ? SoundEvents.field_191258_p : SoundEvents.field_187719_p)))));
            }
            if (!SoundEventHandler.areItemStacksEqual(playerChestplate, storedChestplate)) {
                ipat.setChestplate(PlayerArmorTracker.saveItemStackToNBT(playerChestplate));
            }
            if (playerHelmet != null && !playerHelmet.func_190926_b() && (storedHelmet == null || storedHelmet.func_190926_b() || !storedHelmet.func_190926_b() && (!playerHelmet.func_77973_b().equals(storedHelmet.func_77973_b()) || playerHelmet.func_77978_p() == null && storedHelmet.func_77978_p() != null || playerHelmet.func_77978_p() != null && !playerHelmet.func_77978_p().equals((Object)storedHelmet.func_77978_p())))) {
                itemEquippedSound = playerHelmet.func_77973_b() == Items.field_151020_U ? SoundEvents.field_187713_n : (playerHelmet.func_77973_b() == Items.field_151161_ac ? SoundEvents.field_187716_o : (playerHelmet.func_77973_b() == Items.field_151169_ag ? SoundEvents.field_187722_q : (playerHelmet.func_77973_b() == Items.field_151028_Y ? SoundEvents.field_187725_r : (playerHelmet.func_77973_b() == Items.field_151024_Q ? SoundEvents.field_187728_s : SoundEvents.field_187719_p))));
            }
            if (!SoundEventHandler.areItemStacksEqual(playerHelmet, storedHelmet)) {
                ipat.setHelmet(PlayerArmorTracker.saveItemStackToNBT(playerHelmet));
            }
            if (itemEquippedSound != null && GeneralConfig.armorequipSounds) {
                player.field_70170_p.func_184133_a((EntityPlayer)null, player.func_180425_c(), itemEquippedSound, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            BlockPos pos;
            EntityPlayer player = event.getEntityPlayer();
            ItemStack itemStack = event.getHand() == EnumHand.MAIN_HAND ? player.func_184614_ca() : player.func_184592_cb();
            RayTraceResult raytrace = SoundEventHandler.rayTrace(world, player, true);
            if (itemStack != null && itemStack.func_77973_b() == Items.field_151137_ax && event instanceof PlayerInteractEvent.RightClickBlock && GeneralConfig.redstoneSounds) {
                BlockPos blockpos;
                pos = event.getPos();
                EnumFacing facing = event.getFace();
                boolean flag = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
                BlockPos blockPos = blockpos = flag ? pos : pos.func_177972_a(facing);
                if (player.func_175151_a(blockpos, facing, itemStack) && world.func_190527_a(world.func_180495_p(blockpos).func_177230_c(), blockpos, false, facing, (Entity)null) && Blocks.field_150488_af.func_176196_c(world, blockpos)) {
                    world.func_184133_a((EntityPlayer)null, blockpos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return;
                }
            }
            if (itemStack != null && itemStack.func_77973_b() instanceof IPlantable && event instanceof PlayerInteractEvent.RightClickBlock && GeneralConfig.cropplantingSounds) {
                EnumFacing side = event.getFace();
                if (side != EnumFacing.UP) {
                    return;
                }
                if (player.func_175151_a(event.getPos(), side, itemStack) && world.func_180495_p(event.getPos()).func_177230_c().canSustainPlant(world.func_180495_p(event.getPos().func_177977_b()), (IBlockAccess)world, event.getPos(), EnumFacing.UP, (IPlantable)itemStack.func_77973_b()) && world.func_175623_d(event.getPos().func_177984_a())) {
                    if (world.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150458_ak) {
                        world.func_184133_a((EntityPlayer)null, event.getPos(), SoundEventsASMC.ITEM_CROP_PLANT, SoundCategory.BLOCKS, 0.45f, world.field_73012_v.nextBoolean() ? 1.0f : 1.2f);
                        return;
                    }
                    if (world.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150425_aM) {
                        world.func_184133_a((EntityPlayer)null, event.getPos(), SoundEventsASMC.ITEM_NETHERWART_PLANT, SoundCategory.BLOCKS, 0.9f, world.field_73012_v.nextBoolean() ? 1.0f : 1.12f);
                        return;
                    }
                }
            }
            if (itemStack != null && GeneralConfig.lilypadSounds) {
                if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150392_bi) || itemStack.func_77973_b().func_77658_a().toLowerCase().contains("waterlily") || itemStack.func_77973_b().func_77658_a().toLowerCase().contains("lilypad")) {
                    if (event instanceof PlayerInteractEvent.RightClickBlock) {
                        BlockPos pos_mutable = event.getPos();
                        if (world.func_180495_p(pos_mutable).func_177230_c() != Blocks.field_150431_aC && !world.func_175623_d(pos_mutable = pos_mutable.func_177972_a(event.getFace()))) {
                            return;
                        }
                        if (!player.func_175151_a(pos_mutable, event.getFace(), itemStack)) {
                            return;
                        }
                        if (Blocks.field_150392_bi.func_176196_c(world, pos_mutable)) {
                            world.func_184133_a((EntityPlayer)null, pos_mutable, SoundEvents.field_187916_gp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            return;
                        }
                    }
                    if (raytrace == null) {
                        return;
                    }
                    if (raytrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                        pos = raytrace.func_178782_a();
                        if (!world.func_175660_a(player, pos)) {
                            return;
                        }
                        if (!player.func_175151_a(pos, raytrace.field_178784_b, itemStack)) {
                            return;
                        }
                        boolean isValidLilypadPlace = false;
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                            isValidLilypadPlace = true;
                        }
                        if (isValidLilypadPlace && itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150392_bi)) {
                            world.func_184133_a((EntityPlayer)null, player.func_180425_c(), SoundEventsASMC.BLOCK_LILYPAD_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            return;
                        }
                    }
                }
                if (itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150392_bi) && (itemStack.func_77973_b().func_77658_a().toLowerCase().contains("waterlily") || itemStack.func_77973_b().func_77658_a().toLowerCase().contains("lilypad"))) {
                    if (raytrace == null) {
                        return;
                    }
                    RayTraceResult.Type cfr_ignored_0 = raytrace.field_72313_a;
                    if (raytrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                        pos = raytrace.func_178782_a();
                        if (!world.func_175660_a(player, pos)) {
                            return;
                        }
                        if (!player.func_175151_a(pos, raytrace.field_178784_b, itemStack)) {
                            return;
                        }
                        boolean isValidLilypadPlace = false;
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j && world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                            isValidLilypadPlace = true;
                        }
                        if (isValidLilypadPlace && event instanceof PlayerInteractEvent.RightClickEmpty) {
                            world.func_184133_a((EntityPlayer)null, player.func_180425_c(), SoundEventsASMC.BLOCK_LILYPAD_PLACE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            return;
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        World world = event.getTarget().field_70170_p;
        if (!world.field_72995_K) {
            ItemStack heldItemStack;
            Entity target = event.getTarget();
            EntityPlayer player = event.getEntityPlayer();
            ItemStack itemStack = heldItemStack = event.getHand() == EnumHand.MAIN_HAND ? player.func_184614_ca() : player.func_184592_cb();
            if (target instanceof EntityMooshroom && heldItemStack != null && heldItemStack.func_77973_b() == Items.field_151054_z && !player.field_71075_bZ.field_75098_d && GeneralConfig.mooshroommilkingSounds) {
                target.func_184185_a(SoundEventsASMC.ENTITY_MOOSHROOM_MILK, 1.0f, 0.9f + (float)(world.field_73012_v.nextInt(3) - 1) * 0.1f);
                return;
            }
        }
    }

    protected static RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)playerIn).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        }
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA == null && stackB == null) {
            return true;
        }
        return stackA != null && stackB != null ? SoundEventHandler.isItemStackEqual(stackA, stackB) : false;
    }

    private static boolean isItemStackEqual(ItemStack thisstack, ItemStack other) {
        if (thisstack.func_190916_E() != other.func_190916_E()) {
            return false;
        }
        if (thisstack.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (thisstack.func_77952_i() != other.func_77952_i()) {
            return false;
        }
        if (thisstack.func_77978_p() == null && other.func_77978_p() != null) {
            return false;
        }
        return (thisstack.func_77978_p() == null || thisstack.func_77978_p().equals((Object)other.func_77978_p())) && thisstack.areCapsCompatible(other);
    }
}

