/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.coremodlib;

import java.util.StringJoiner;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodDefinition {
    private final String className;
    private final boolean itf;
    private final String methodName;
    private final Type returnType;
    private final Type[] args;
    private final String desc;

    public MethodDefinition(String className, boolean classIsInterface, String methodName, Type returnType, Type ... args) {
        this.className = className;
        this.itf = classIsInterface;
        this.methodName = methodName;
        this.returnType = returnType;
        this.args = args;
        this.desc = Type.getMethodDescriptor((Type)returnType, (Type[])args);
    }

    public String name() {
        return this.methodName;
    }

    public String declaringClass() {
        return this.className;
    }

    public boolean declaringClassIsInterface() {
        return this.itf;
    }

    public String desc() {
        return this.desc;
    }

    public Type returnType() {
        return this.returnType;
    }

    public Type[] argumentTypes() {
        return this.args;
    }

    public MethodInsnNode asMethodInsnNode(int opcode) {
        return new MethodInsnNode(opcode, this.className, this.methodName, this.desc, this.itf);
    }

    public MethodNode createNewMethodNode(int access) {
        return new MethodNode(327680, access, this.methodName, this.desc, null, null);
    }

    public String toString() {
        StringJoiner argJoiner = new StringJoiner(", ");
        for (Type t : this.args) {
            argJoiner.add(t.getClassName());
        }
        return String.format("%s %s.%s(%s)", this.returnType.getClassName(), this.className, this.methodName, argJoiner.toString());
    }
}

