/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.coremodlib;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import thecodex6824.coremodlib.ASMUtil;
import thecodex6824.coremodlib.InstructionMatcher;
import thecodex6824.coremodlib.MatchAction;
import thecodex6824.coremodlib.MatchDetails;
import thecodex6824.coremodlib.MatchResult;
import thecodex6824.coremodlib.MatchSnapshot;
import thecodex6824.coremodlib.MatchTransformer;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.MutableMatchDetails;
import thecodex6824.coremodlib.PatchBuilders;

public class PatchStateMachine {
    private final MethodDefinition method;
    private final ImmutableList<InstructionStateMachineNode> nodes;

    protected PatchStateMachine(MethodDefinition method, ImmutableList<InstructionStateMachineNode> nodes) {
        this.method = method;
        this.nodes = nodes;
    }

    public EvaluationResult evaluate(MethodNode methodNode) {
        return this.evaluate(methodNode, (Set<AbstractInsnNode>)ImmutableSet.of());
    }

    public EvaluationResult evaluate(MethodNode methodNode, Set<AbstractInsnNode> ignoreMatches) {
        ArrayList<MatchResult> liveMatches = new ArrayList<MatchResult>();
        ArrayList<MatchSnapshot> snapshotMatches = new ArrayList<MatchSnapshot>();
        ArrayList<EvaluationStep> steps = new ArrayList<EvaluationStep>();
        InstructionStateMachineNode lastNode = null;
        boolean complete = false;
        int currentNode = 0;
        for (int i = 0; i < methodNode.instructions.size(); ++i) {
            MatchResult result;
            AbstractInsnNode node = methodNode.instructions.get(i);
            if (ignoreMatches.contains(node) || !(result = (lastNode = (InstructionStateMachineNode)this.nodes.get(currentNode)).matches(methodNode, node, liveMatches)).matched()) continue;
            liveMatches.add(result);
            snapshotMatches.add(result.makeSnapshot());
            ignoreMatches.add(node);
            ignoreMatches.addAll(lastNode.runMatchActions(methodNode, result, liveMatches));
            steps.add(new EvaluationStep(lastNode, methodNode.instructions, snapshotMatches));
            if (++currentNode < this.nodes.size()) continue;
            complete = true;
            break;
        }
        if (!complete) {
            steps.add(new EvaluationStep(lastNode, methodNode.instructions, snapshotMatches));
        }
        return new EvaluationResult(complete, steps);
    }

    public MethodDefinition targetMethod() {
        return this.method;
    }

    public static PatchBuilders.TransformerBuilder builder(MethodDefinition method) {
        return new PatchBuilders.TransformerBuilder(method);
    }

    public static class EvaluationResult {
        private final boolean completed;
        private final List<EvaluationStep> steps;

        protected EvaluationResult(boolean completed, List<EvaluationStep> steps) {
            this.completed = completed;
            this.steps = ImmutableList.copyOf(steps);
        }

        public boolean evaluationFullyCompleted() {
            return this.completed;
        }

        public boolean evaluationHadAnyMatch() {
            if (!this.steps.isEmpty()) {
                for (MatchSnapshot result : this.steps.get(this.steps.size() - 1).allMatches) {
                    if (!result.matched()) continue;
                    return true;
                }
            }
            return false;
        }

        public List<? extends MatchDetails> matchResults() {
            return !this.steps.isEmpty() ? this.steps.get(this.steps.size() - 1).allMatches : ImmutableList.of();
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            for (int i = 0; i < this.steps.size(); ++i) {
                output.append(String.format("Results of step %d%n", i + 1));
                output.append(this.steps.get(i).toString());
                output.append(System.lineSeparator());
            }
            return output.toString();
        }
    }

    protected static class EvaluationStep {
        private final InstructionStateMachineNode node;
        private final List<MatchSnapshot> allMatches;
        private final InsnList instructions;
        private String cachedBytecode;

        public EvaluationStep(InstructionStateMachineNode nodeChecked, InsnList currentInstructions, List<MatchSnapshot> matches) {
            this.node = nodeChecked;
            this.instructions = ASMUtil.cloneInsnList(currentInstructions);
            this.allMatches = ImmutableList.copyOf(matches);
        }

        public String getBytecodeAfterEvaluation() {
            if (this.cachedBytecode == null) {
                StringWriter writer = new StringWriter();
                TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
                this.instructions.accept((MethodVisitor)visitor);
                visitor.p.print(new PrintWriter(writer));
                this.cachedBytecode = writer.toString();
            }
            return this.cachedBytecode;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            MatchSnapshot result = null;
            result = !this.allMatches.isEmpty() ? this.allMatches.get(this.allMatches.size() - 1) : new MatchSnapshot(null, null, null, null);
            builder.append(String.format("Match details: %s", this.node.describe(result, this.allMatches)));
            if (result.matched()) {
                builder.append(String.format("Resulting bytecode: %n%n%s%n", this.getBytecodeAfterEvaluation()));
            }
            return builder.toString();
        }
    }

    protected static class InstructionStateMachineNode {
        private final InstructionMatcher matcher;
        private final ImmutableList<MatchTransformer> transformers;
        private final ImmutableList<MatchAction> actions;

        public InstructionStateMachineNode(InstructionMatcher matcher, List<MatchTransformer> transformers, List<MatchAction> actions) {
            this.matcher = matcher;
            this.transformers = ImmutableList.copyOf(transformers);
            this.actions = ImmutableList.copyOf(actions);
        }

        public MatchResult matches(MethodNode method, AbstractInsnNode node, List<? extends MutableMatchDetails> previousMatches) {
            MatchResult result = this.matcher.matches(method, node);
            if (result.matched()) {
                for (MatchTransformer transformer : this.transformers) {
                    transformer.transformMatch(method, result, previousMatches);
                }
            }
            return result;
        }

        public Collection<AbstractInsnNode> runMatchActions(MethodNode method, MatchDetails result, List<? extends MatchDetails> matches) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MatchAction action : this.actions) {
                builder.addAll(action.onMatch(method, result, matches));
            }
            return builder.build();
        }

        public String describe(MatchSnapshot result, List<MatchSnapshot> matches) {
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("    Condition: %s%n", this.matcher.toString()));
            if (result.originalStart() != result.matchStart() || result.originalEnd() != result.matchEnd()) {
                builder.append(String.format("    Match was modified:%n    Before:%s%n    After:%s%n", ASMUtil.dumpBytecode(result.originalStart(), result.originalEnd()), ASMUtil.dumpBytecode(result.matchStart(), result.matchEnd())));
            }
            if (result.matched()) {
                builder.append("    Executed actions:" + System.lineSeparator());
                for (MatchAction action : this.actions) {
                    builder.append("        " + action.describe(result, matches));
                }
            } else {
                builder.append(String.format("    Condition was not matched%n", new Object[0]));
            }
            return builder.toString();
        }
    }
}

