/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.coremodlib;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import thecodex6824.coremodlib.ASMUtil;
import thecodex6824.coremodlib.MatchAction;
import thecodex6824.coremodlib.MatchDetails;

public class PrefabMatchActions {
    private static final String INSN_SEPARATOR = String.copyValueOf(ArrayUtils.toPrimitive((Character[])Collections.nCopies(80, Character.valueOf('-')).toArray(new Character[80])));
    private static final String SURROUND_SEPARATOR = String.copyValueOf(ArrayUtils.toPrimitive((Character[])Collections.nCopies(80, Character.valueOf('=')).toArray(new Character[80])));

    public static class InsertInstructionsSurroundingMatch
    implements MatchAction {
        private final InsnList before;
        private final InsnList after;

        public InsertInstructionsSurroundingMatch(InsnList before, InsnList after) {
            this.before = before;
            this.after = after;
        }

        @Override
        public Collection<AbstractInsnNode> onMatch(MethodNode method, MatchDetails result, List<? extends MatchDetails> matches) {
            Map<LabelNode, LabelNode> labelMap = ASMUtil.makeLabelCloneMap(this.before.iterator(), (Map<LabelNode, LabelNode>)ImmutableMap.of());
            labelMap = ASMUtil.makeLabelCloneMap(this.after.iterator(), labelMap);
            ImmutableList.Builder ret = ImmutableList.builder();
            InsnList beforeWorking = ASMUtil.cloneInsnList(this.before, labelMap);
            ret.addAll((Iterator)beforeWorking.iterator());
            method.instructions.insertBefore(result.matchStart(), beforeWorking);
            InsnList afterWorking = ASMUtil.cloneInsnList(this.after, labelMap);
            ret.addAll((Iterator)afterWorking.iterator());
            method.instructions.insert(result.matchEnd(), afterWorking);
            return ret.build();
        }

        @Override
        public String describe(MatchDetails result, List<? extends MatchDetails> matches) {
            StringBuilder output = new StringBuilder();
            output.append("Inserting instructions SURROUNDING (before and after) target:");
            output.append(System.lineSeparator());
            AbstractInsnNode target = result.matchStart();
            StringWriter traceOutput = new StringWriter();
            TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
            AbstractInsnNode prev = target.getPrevious();
            for (int i = 0; prev != null && i < this.before.size(); prev = prev.getPrevious(), ++i) {
            }
            if (prev != null) {
                prev.accept((MethodVisitor)visitor);
                visitor.p.print(new PrintWriter(traceOutput));
                output.append(traceOutput.toString());
                visitor.p.text.clear();
                traceOutput = new StringWriter();
            } else {
                output.append("<start of instruction list>");
                output.append(System.lineSeparator());
            }
            output.append(INSN_SEPARATOR);
            output.append(System.lineSeparator());
            this.before.accept((MethodVisitor)visitor);
            visitor.p.print(new PrintWriter(traceOutput));
            output.append(traceOutput.toString());
            visitor.p.text.clear();
            traceOutput = new StringWriter();
            output.append(System.lineSeparator());
            output.append(SURROUND_SEPARATOR);
            output.append(System.lineSeparator());
            while (target != result.matchEnd().getNext()) {
                target.accept((MethodVisitor)visitor);
                target = target.getNext();
            }
            visitor.p.print(new PrintWriter(traceOutput));
            output.append(traceOutput.toString());
            visitor.p.text.clear();
            traceOutput = new StringWriter();
            output.append(SURROUND_SEPARATOR);
            output.append(System.lineSeparator());
            this.after.accept((MethodVisitor)visitor);
            visitor.p.print(new PrintWriter(traceOutput));
            output.append(traceOutput.toString());
            visitor.p.text.clear();
            traceOutput = new StringWriter();
            output.append(INSN_SEPARATOR);
            output.append(System.lineSeparator());
            AbstractInsnNode next = target;
            for (int i = 0; next != null && i < this.after.size(); next = next.getNext(), ++i) {
            }
            if (next != null) {
                next.accept((MethodVisitor)visitor);
                visitor.p.print(new PrintWriter(traceOutput));
                output.append(traceOutput.toString());
                visitor.p.text.clear();
                traceOutput = new StringWriter();
            } else {
                output.append("<end of instruction list>");
                output.append(System.lineSeparator());
            }
            return output.toString();
        }
    }

    public static class InsertInstructionsAfterMatch
    implements MatchAction {
        private final InsnList instructions;

        public InsertInstructionsAfterMatch(InsnList list) {
            this.instructions = list;
        }

        @Override
        public Collection<AbstractInsnNode> onMatch(MethodNode method, MatchDetails result, List<? extends MatchDetails> matches) {
            InsnList workingCopy = ASMUtil.cloneInsnList(this.instructions);
            ImmutableList ret = ImmutableList.copyOf((Iterator)workingCopy.iterator());
            method.instructions.insert(result.matchEnd(), workingCopy);
            return ret;
        }

        @Override
        public String describe(MatchDetails result, List<? extends MatchDetails> matches) {
            StringBuilder output = new StringBuilder();
            output.append("Inserting instructions AFTER target:");
            output.append(System.lineSeparator());
            AbstractInsnNode target = result.matchEnd();
            StringWriter traceOutput = new StringWriter();
            TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
            if (target.getPrevious() != null) {
                target.getPrevious().accept((MethodVisitor)visitor);
                visitor.p.print(new PrintWriter(traceOutput));
                output.append(traceOutput.toString());
                visitor.p.text.clear();
                traceOutput = new StringWriter();
            } else {
                output.append("<start of instruction list>");
                output.append(System.lineSeparator());
            }
            output.append(SURROUND_SEPARATOR);
            output.append(System.lineSeparator());
            target.accept((MethodVisitor)visitor);
            visitor.p.print(new PrintWriter(traceOutput));
            output.append(traceOutput.toString());
            visitor.p.text.clear();
            traceOutput = new StringWriter();
            output.append(SURROUND_SEPARATOR);
            output.append(System.lineSeparator());
            this.instructions.accept((MethodVisitor)visitor);
            visitor.p.print(new PrintWriter(traceOutput));
            output.append(traceOutput.toString());
            visitor.p.text.clear();
            traceOutput = new StringWriter();
            output.append(INSN_SEPARATOR);
            output.append(System.lineSeparator());
            AbstractInsnNode next = target.getNext();
            for (int i = 0; next != null && i < this.instructions.size(); next = next.getNext(), ++i) {
            }
            if (next != null) {
                next.accept((MethodVisitor)visitor);
                visitor.p.print(new PrintWriter(traceOutput));
                output.append(traceOutput.toString());
                visitor.p.text.clear();
                traceOutput = new StringWriter();
            } else {
                output.append("<end of instruction list>");
                output.append(System.lineSeparator());
            }
            return output.toString();
        }
    }

    public static class InsertInstructionsBeforeMatch
    implements MatchAction {
        private final InsnList instructions;

        public InsertInstructionsBeforeMatch(InsnList list) {
            this.instructions = list;
        }

        @Override
        public Collection<AbstractInsnNode> onMatch(MethodNode method, MatchDetails result, List<? extends MatchDetails> matches) {
            InsnList workingCopy = ASMUtil.cloneInsnList(this.instructions);
            ImmutableList ret = ImmutableList.copyOf((Iterator)workingCopy.iterator());
            method.instructions.insertBefore(result.matchStart(), workingCopy);
            return ret;
        }

        @Override
        public String describe(MatchDetails result, List<? extends MatchDetails> matches) {
            StringBuilder output = new StringBuilder();
            output.append("Inserting instructions BEFORE target:");
            output.append(System.lineSeparator());
            AbstractInsnNode target = result.matchStart();
            StringWriter traceOutput = new StringWriter();
            TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)new Textifier());
            AbstractInsnNode prev = target.getPrevious();
            for (int i = 0; prev != null && i < this.instructions.size(); prev = prev.getPrevious(), ++i) {
            }
            if (prev != null) {
                prev.accept((MethodVisitor)visitor);
                visitor.p.print(new PrintWriter(traceOutput));
                output.append(traceOutput.toString());
                visitor.p.text.clear();
                traceOutput = new StringWriter();
            } else {
                output.append("<start of instruction list>");
                output.append(System.lineSeparator());
            }
            output.append(INSN_SEPARATOR);
            output.append(System.lineSeparator());
            this.instructions.accept((MethodVisitor)visitor);
            visitor.p.print(new PrintWriter(traceOutput));
            output.append(traceOutput.toString());
            visitor.p.text.clear();
            traceOutput = new StringWriter();
            output.append(System.lineSeparator());
            output.append(SURROUND_SEPARATOR);
            output.append(System.lineSeparator());
            target.accept((MethodVisitor)visitor);
            visitor.p.print(new PrintWriter(traceOutput));
            output.append(traceOutput.toString());
            visitor.p.text.clear();
            traceOutput = new StringWriter();
            output.append(SURROUND_SEPARATOR);
            output.append(System.lineSeparator());
            if (target.getNext() != null) {
                target.getNext().accept((MethodVisitor)visitor);
                visitor.p.print(new PrintWriter(traceOutput));
                output.append(traceOutput.toString());
                visitor.p.text.clear();
                traceOutput = new StringWriter();
            } else {
                output.append("<end of instruction list>");
                output.append(System.lineSeparator());
            }
            return output.toString();
        }
    }

    public static class GenericAction
    implements MatchAction {
        private final BiFunction<MethodNode, List<? extends MatchDetails>, Collection<AbstractInsnNode>> action;

        public GenericAction(BiFunction<MethodNode, List<? extends MatchDetails>, Collection<AbstractInsnNode>> customAction) {
            this.action = customAction;
        }

        @Override
        public Collection<AbstractInsnNode> onMatch(MethodNode method, MatchDetails result, List<? extends MatchDetails> matches) {
            return this.action.apply(method, matches);
        }

        @Override
        public String describe(MatchDetails result, List<? extends MatchDetails> matches) {
            return "Generic action, no details :(";
        }
    }

    public static class DoNothing
    implements MatchAction {
        @Override
        public Collection<AbstractInsnNode> onMatch(MethodNode method, MatchDetails result, List<? extends MatchDetails> matches) {
            return ImmutableList.of();
        }

        @Override
        public String describe(MatchDetails result, List<? extends MatchDetails> matches) {
            return "No action (no-op)";
        }
    }
}

