/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.api.aura;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import thecodex6824.thaumcraftfix.api.aura.IAuraChunk;
import thecodex6824.thaumcraftfix.api.aura.IAuraProcessor;
import thecodex6824.thaumcraftfix.api.aura.IAuraWorld;

public class DefaultAuraProcessor
implements IAuraProcessor {
    protected static final PhaseModifier[] PHASE_TO_AURA_MODS = new PhaseModifier[]{new PhaseModifier(0.25f, 1.15f), new PhaseModifier(0.15f, 1.05f), new PhaseModifier(0.1f, 1.0f), new PhaseModifier(0.05f, 0.95f), new PhaseModifier(0.0f, 0.85f), new PhaseModifier(0.05f, 0.95f), new PhaseModifier(0.1f, 1.0f), new PhaseModifier(0.15f, 1.05f)};
    protected static final int TICK_RATE = 20;
    protected volatile int lastMoonPhase;
    protected volatile long totalWorldTime;
    protected long lastUpdateTime;

    @Override
    public void gameTick(World world) {
        this.lastMoonPhase = world.field_73011_w.func_76559_b(world.func_72820_D()) % PHASE_TO_AURA_MODS.length;
        this.totalWorldTime = world.func_82737_E();
    }

    @Override
    public void auraTick(IAuraWorld world) {
        if (Math.abs(this.totalWorldTime - this.lastUpdateTime) >= 20L) {
            this.lastUpdateTime = this.totalWorldTime;
            for (IAuraChunk chunk : world.getAllAuraChunks()) {
                this.equalizeWithNeighbors(world, chunk);
                this.generateVisAndFlux(world, chunk);
                this.checkForRifts(world, chunk);
            }
        }
    }

    protected void equalizeWithNeighbors(IAuraWorld world, IAuraChunk center) {
        ArrayList offsets = Lists.newArrayList((Object[])new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST});
        Collections.shuffle(offsets, ThreadLocalRandom.current());
        int centerX = center.getPosition().field_77276_a;
        int centerZ = center.getPosition().field_77275_b;
        IAuraChunk lowestVis = null;
        IAuraChunk lowestFlux = null;
        for (EnumFacing offset : offsets) {
            IAuraChunk chunk = world.getAuraChunk(centerX + offset.func_82601_c(), centerZ + offset.func_82599_e());
            if (chunk == null) continue;
            if ((lowestVis == null || lowestVis.getVis() > chunk.getVis()) && chunk.getVis() + chunk.getFlux() < (float)chunk.getBase() * DefaultAuraProcessor.PHASE_TO_AURA_MODS[this.lastMoonPhase].baseMultiplier) {
                lowestVis = chunk;
            }
            if (lowestFlux != null && !(lowestFlux.getFlux() > chunk.getFlux())) continue;
            lowestFlux = chunk;
        }
        float myVis = center.getVis();
        if (lowestVis != null && lowestVis.getVis() < myVis && lowestVis.getVis() / myVis < 0.75f) {
            float inc = Math.min(myVis - lowestVis.getVis(), 1.0f);
            inc = -center.addVis(-inc);
            lowestVis.addVis(inc);
        }
        float myFlux = center.getFlux();
        if (lowestFlux != null && myFlux > Math.max(5.0f, (float)center.getBase() / 10.0f) && lowestFlux.getFlux() < myFlux / 1.75f) {
            float inc = Math.min(myFlux - lowestFlux.getFlux(), 1.0f);
            inc = -center.addFlux(-inc);
            lowestFlux.addFlux(inc);
        }
    }

    protected void generateVisAndFlux(IAuraWorld world, IAuraChunk chunk) {
        float vis = chunk.getVis();
        float flux = chunk.getFlux();
        short base = chunk.getBase();
        PhaseModifier phase = PHASE_TO_AURA_MODS[this.lastMoonPhase];
        float phaseFlux = DefaultAuraProcessor.PHASE_TO_AURA_MODS[0].auraChange - phase.auraChange;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        if (vis + flux < (float)base) {
            float inc = Math.min((float)base - vis + flux, phase.auraChange);
            chunk.addVis(inc);
        } else if (vis > (float)base * 1.25f && ((Random)rand).nextFloat() < 0.1f) {
            chunk.addFlux(phaseFlux);
            chunk.addVis(-phaseFlux);
        } else if (vis <= (float)base * 0.1f && vis >= flux && ((Random)rand).nextFloat() < 0.1f) {
            chunk.addFlux(phaseFlux);
        }
    }

    protected void checkForRifts(IAuraWorld world, IAuraChunk chunk) {
        float flux = chunk.getFlux();
        if (flux > (float)chunk.getBase() * 0.75f && ThreadLocalRandom.current().nextFloat() < flux / 500.0f / 10.0f) {
            ChunkPos pos = chunk.getPosition();
            world.markPositionForRift(new BlockPos(pos.field_77276_a * 16, 0, pos.field_77275_b * 16), true);
        }
    }

    protected static final class PhaseModifier {
        public final float auraChange;
        public final float baseMultiplier;

        public PhaseModifier(float auraMod, float baseMod) {
            this.auraChange = auraMod;
            this.baseMultiplier = baseMod;
        }
    }
}

