/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.client;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.lib.events.RenderEventHandler;
import thaumcraft.common.entities.monster.EntityFireBat;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.items.ItemTCBase;
import thaumcraft.common.items.tools.ItemThaumometer;
import thecodex6824.thaumcraftfix.ThaumcraftFix;

@Mod.EventBusSubscriber(modid="thaumcraftfix", value={Side.CLIENT})
public class ClientEventHandler {
    private static Field PARTICLES = null;
    private static Field PARTICLES_DELAYED = null;
    private static Field PARTICLE_DELAY_DIM = null;
    private static final float[] BURST_SIZES = new float[]{4.5f, 10.0f};

    @SubscribeEvent
    public static void onRegisterModels(ModelRegistryEvent event) {
        ItemTCBase pearl = (ItemTCBase)ItemsTC.primordialPearl;
        ModelResourceLocation model = pearl.getCustomModelResourceLocation(pearl.getVariantNames()[0]);
        for (int i = 0; i < 8; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)ItemsTC.primordialPearl, (int)i, (ModelResourceLocation)model);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        if (event.getEntityLiving().func_130014_f_().field_72995_K && (entity = event.getEntityLiving()) instanceof EntityFireBat) {
            World world = entity.func_130014_f_();
            Random random = entity.func_70681_au();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entity.field_70169_q + (double)((random.nextFloat() - random.nextFloat()) * 0.2f), entity.field_70167_r + (double)(entity.field_70131_O / 2.0f) + (double)((random.nextFloat() - random.nextFloat()) * 0.2f), entity.field_70166_s + (double)((random.nextFloat() - random.nextFloat()) * 0.2f), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, entity.field_70169_q + (double)((random.nextFloat() - random.nextFloat()) * 0.2f), entity.field_70167_r + (double)(entity.field_70131_O / 2.0f) + (double)((random.nextFloat() - random.nextFloat()) * 0.2f), entity.field_70166_s + (double)((random.nextFloat() - random.nextFloat()) * 0.2f), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityLivingBase living;
            Entity renderView;
            boolean validMeter = false;
            Entity thaum = RenderEventHandler.thaumTarget;
            if (thaum != null && !thaum.field_70128_L && (!(thaum instanceof EntityLivingBase) || ((EntityLivingBase)thaum).func_110143_aJ() > 0.0f) && (renderView = Minecraft.func_71410_x().func_175606_aa()) instanceof EntityLivingBase && ((living = (EntityLivingBase)renderView).func_184614_ca().func_77973_b() instanceof ItemThaumometer || living.func_184592_cb().func_77973_b() instanceof ItemThaumometer)) {
                validMeter = true;
            }
            if (!validMeter) {
                RenderEventHandler.thaumTarget = null;
            }
        }
    }

    private static int getDimension(Object particleDelay) {
        try {
            return PARTICLE_DELAY_DIM.getInt(particleDelay);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @SubscribeEvent
    public static void onClientWorldUnload(WorldEvent.Unload event) {
        int unloadedDim = event.getWorld().field_73011_w.getDimension();
        try {
            if (PARTICLES == null || PARTICLES_DELAYED == null || PARTICLE_DELAY_DIM == null) {
                PARTICLES = ParticleEngine.class.getDeclaredField("particles");
                PARTICLES.setAccessible(true);
                PARTICLES_DELAYED = ParticleEngine.class.getDeclaredField("particlesDelayed");
                PARTICLES_DELAYED.setAccessible(true);
                Class<?> particleDelay = null;
                for (Class<?> c : ParticleEngine.class.getDeclaredClasses()) {
                    if (!c.getSimpleName().equals("ParticleDelay")) continue;
                    particleDelay = c;
                    break;
                }
                if (particleDelay == null) {
                    throw new RuntimeException("Can't find ParticleEngine$ParticleDelay");
                }
                PARTICLE_DELAY_DIM = particleDelay.getDeclaredField("dim");
                PARTICLE_DELAY_DIM.setAccessible(true);
            }
            Map[] particleMaps = (Map[])PARTICLES.get(null);
            for (int layer = 0; layer < particleMaps.length; ++layer) {
                List list = (List)particleMaps[layer].get(unloadedDim);
                if (list == null) continue;
                for (Particle p2 : list) {
                    p2.func_187112_i();
                }
                list.clear();
            }
            List delayed = (List)PARTICLES_DELAYED.get(null);
            delayed.removeIf(p -> ClientEventHandler.getDimension(p) == unloadedDim);
        }
        catch (Exception ex) {
            ThaumcraftFix.instance.getLogger().error("Failed to clear Thaumcraft particle lists", (Throwable)ex);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity;
        if (event.getEntityLiving().func_130014_f_().field_72995_K && (entity = event.getEntityLiving()) instanceof EntityWisp) {
            for (float size : BURST_SIZES) {
                FXDispatcher.INSTANCE.burst(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O / 2.0, entity.field_70161_v, size);
            }
        }
    }
}

