/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.aura;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.common.world.aura.AuraChunk;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.aura.IAuraChunk;

public class AtomicAuraChunk
extends AuraChunk
implements IAuraChunk {
    private static final int MAX_AURA = Short.MAX_VALUE;
    private AtomicInteger baseAtomic;
    private AtomicDouble visAtomic;
    private AtomicDouble fluxAtomic;
    private volatile boolean modified;

    public AtomicAuraChunk(Chunk chunk, short base, float vis, float flux) {
        super(chunk, base, vis, flux);
        this.baseAtomic = new AtomicInteger(Math.max(Math.min(base, Short.MAX_VALUE), 0));
        this.visAtomic = new AtomicDouble((double)Math.max(Math.min(vis, 32767.0f), 0.0f));
        this.fluxAtomic = new AtomicDouble((double)Math.max(Math.min(flux, 32767.0f), 0.0f));
    }

    public AtomicAuraChunk(ChunkPos pos) {
        super(pos);
        this.baseAtomic = new AtomicInteger(0);
        this.visAtomic = new AtomicDouble(0.0);
        this.fluxAtomic = new AtomicDouble(0.0);
    }

    @Override
    public ChunkPos getPosition() {
        return this.getLoc();
    }

    @Override
    public short getBase() {
        return this.baseAtomic.shortValue();
    }

    @Override
    public void setBase(short base) {
        this.baseAtomic.set(Math.max(Math.min(base, Short.MAX_VALUE), 0));
        this.modified = true;
    }

    @Override
    public boolean compareAndSetBase(short compare, short newValue) {
        boolean res = this.baseAtomic.compareAndSet(compare, newValue);
        if (res) {
            this.modified = true;
        }
        return res;
    }

    @Override
    public short addBase(short add) {
        short target;
        short current;
        while ((current = this.baseAtomic.shortValue()) != (target = (short)Math.max(Math.min(current + add, Short.MAX_VALUE), 0)) && !this.visAtomic.compareAndSet((double)current, (double)target)) {
        }
        this.modified = true;
        return (short)(target - current);
    }

    @Override
    public short getAndSetBase(short set) {
        short res = (short)this.baseAtomic.getAndSet(Math.max(Math.min(set, Short.MAX_VALUE), 0));
        this.modified = true;
        return res;
    }

    @Override
    public float getVis() {
        return this.visAtomic.floatValue();
    }

    @Override
    public void setVis(float newVis) {
        this.visAtomic.set((double)Math.max(Math.min(newVis, 32767.0f), 0.0f));
        this.modified = true;
    }

    @Override
    public boolean compareAndSetVis(float compare, float newValue) {
        boolean res = this.visAtomic.compareAndSet((double)compare, (double)Math.max(Math.min(newValue, 32767.0f), 0.0f));
        if (res) {
            this.modified = true;
        }
        return res;
    }

    @Override
    public float addVis(float add) {
        boolean adjustmentNeeded;
        double target;
        double current;
        do {
            adjustmentNeeded = false;
            current = this.visAtomic.get();
            target = current + (double)add;
            if (!(current + (double)add > 32767.0) && !(current + (double)add < 0.0)) continue;
            target = Math.max(Math.min(current + (double)add, 32767.0), 0.0);
            adjustmentNeeded = true;
        } while (current != target && !this.visAtomic.compareAndSet(current, target));
        this.modified = true;
        return adjustmentNeeded ? (float)(target - current) : add;
    }

    @Override
    public float getAndSetVis(float set) {
        float res = (float)this.visAtomic.getAndSet((double)Math.max(Math.min(set, 32767.0f), 0.0f));
        this.modified = true;
        return res;
    }

    @Override
    public float getFlux() {
        return this.fluxAtomic.floatValue();
    }

    @Override
    public void setFlux(float newFlux) {
        this.fluxAtomic.set((double)Math.max(Math.min(newFlux, 32767.0f), 0.0f));
        this.modified = true;
    }

    @Override
    public boolean compareAndSetFlux(float compare, float newValue) {
        boolean res = this.fluxAtomic.compareAndSet((double)compare, (double)Math.max(Math.min(newValue, 32767.0f), 0.0f));
        if (res) {
            this.modified = true;
        }
        return res;
    }

    @Override
    public float addFlux(float add) {
        boolean adjustmentNeeded;
        double target;
        double current;
        do {
            adjustmentNeeded = false;
            current = this.fluxAtomic.get();
            target = current + (double)add;
            if (!(current + (double)add > 32767.0) && !(current + (double)add < 0.0)) continue;
            target = Math.max(Math.min(current + (double)add, 32767.0), 0.0);
            adjustmentNeeded = true;
        } while (current != target && !this.fluxAtomic.compareAndSet(current, target));
        this.modified = true;
        return adjustmentNeeded ? (float)(target - current) : add;
    }

    @Override
    public float getAndSetFlux(float set) {
        float res = (float)this.fluxAtomic.getAndSet((double)Math.max(Math.min(set, 32767.0f), 0.0f));
        this.modified = true;
        return res;
    }

    public void setLoc(ChunkPos loc) {
        ThaumcraftFix.instance.getLogger().warn("Someone is calling AuraChunk#setLoc, which is unsafe and probably doesn't do what they are expecting");
        ThaumcraftFix.instance.getLogger().warn("If you are the mod author, call removeAuraChunk and addAuraChunk with a new chunk instead");
        super.setLoc(loc);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }
}

