/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.aura;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.common.lib.utils.PosXY;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraWorld;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.aura.IAuraChunk;
import thecodex6824.thaumcraftfix.api.aura.IAuraWorld;
import thecodex6824.thaumcraftfix.common.aura.RiftTriggerEvent;

public class GenericAuraWorld
extends AuraWorld
implements IAuraWorld {
    protected final int dim;

    public GenericAuraWorld(int dim) {
        super(dim);
        this.dim = dim;
    }

    @Override
    public Set<IAuraChunk> getAllAuraChunks() {
        return ImmutableSet.copyOf((Object[])this.getAuraChunks().values().toArray(new IAuraChunk[0]));
    }

    @Override
    @Nullable
    public IAuraChunk getAuraChunk(ChunkPos pos) {
        return this.getAuraChunk(pos.field_77276_a, pos.field_77275_b);
    }

    @Override
    @Nullable
    public IAuraChunk getAuraChunk(int chunkX, int chunkZ) {
        return (IAuraChunk)this.getAuraChunkAt(chunkX, chunkZ);
    }

    @Override
    public void markPositionForRift(BlockPos position, boolean useInexactSpawning) {
        ThaumcraftFix.proxy.scheduleTask(Side.SERVER, () -> {
            WorldServer world = DimensionManager.getWorld((int)this.dim);
            if (world != null) {
                MinecraftForge.EVENT_BUS.post((Event)new RiftTriggerEvent((World)world, position, useInexactSpawning));
            }
        });
    }

    public void addAuraChunk(AuraChunk chunk) {
        ChunkPos pos = chunk.getLoc();
        this.getAuraChunks().put(new PosXY(pos.field_77276_a, pos.field_77275_b), chunk);
    }
}

