/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.OptionalInt;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.common.config.ThaumcraftFixConfigImpl;

public class ThaumcraftFixConfig {
    public ItemConfig item = new ItemConfig();
    public WorldConfig world = new WorldConfig();
    private static final String ITEM_CAT = "item";
    private static final String PEARL = "primordialPearlDamageFix";

    public void bind() {
        this.item.primordialPearlDamageFix.setUserValue(ThaumcraftFixConfigImpl.item.primordialPearlDamageFix);
        this.world.aura.biomeAllowList.setUserValue(ThaumcraftFixConfigImpl.world.aura.biomeAllowList);
        this.world.aura.biomeList.setUserValue(ThaumcraftFixConfigImpl.world.aura.biomeList);
        this.world.aura.controlAura.setUserValue(ThaumcraftFixConfigImpl.world.aura.controlAura);
        this.world.aura.dimAllowList.setUserValue(ThaumcraftFixConfigImpl.world.aura.dimAllowList);
        this.world.aura.dimList.setUserValue(ThaumcraftFixConfigImpl.world.aura.dimList);
        this.world.crystals.biomeAllowList.setUserValue(ThaumcraftFixConfigImpl.world.crystals.biomeAllowList);
        this.world.crystals.biomeList.setUserValue(ThaumcraftFixConfigImpl.world.crystals.biomeList);
        this.world.crystals.controlCrystals.setUserValue(ThaumcraftFixConfigImpl.world.crystals.controlCrystals);
        this.world.crystals.dimAllowList.setUserValue(ThaumcraftFixConfigImpl.world.crystals.dimAllowList);
        this.world.crystals.dimList.setUserValue(ThaumcraftFixConfigImpl.world.crystals.dimList);
        this.world.vegetation.biomeAllowList.setUserValue(ThaumcraftFixConfigImpl.world.vegetation.biomeAllowList);
        this.world.vegetation.biomeList.setUserValue(ThaumcraftFixConfigImpl.world.vegetation.biomeList);
        this.world.vegetation.controlVegetation.setUserValue(ThaumcraftFixConfigImpl.world.vegetation.controlVegetation);
        this.world.vegetation.dimAllowList.setUserValue(ThaumcraftFixConfigImpl.world.vegetation.dimAllowList);
        this.world.vegetation.dimList.setUserValue(ThaumcraftFixConfigImpl.world.vegetation.dimList);
    }

    public void deserializeNetwork(JsonObject json) {
        try {
            JsonElement pearl;
            JsonElement itemCat = json.get(ITEM_CAT);
            if (itemCat != null && (pearl = itemCat.getAsJsonObject().get(PEARL)) != null) {
                this.item.primordialPearlDamageFix.setSessionValue(pearl.getAsBoolean());
            }
        }
        catch (Exception ex) {
            ThaumcraftFix.instance.getLogger().warn("Got invalid data in serialized config");
        }
    }

    public JsonObject serializeNetwork() {
        JsonObject rootCat = new JsonObject();
        JsonObject itemCat = new JsonObject();
        itemCat.add(PEARL, (JsonElement)new JsonPrimitive(Boolean.valueOf(this.item.primordialPearlDamageFix.userValue())));
        rootCat.add(ITEM_CAT, (JsonElement)itemCat);
        return rootCat;
    }

    public static class WorldConfig {
        public AuraConfig aura = new AuraConfig();
        public CrystalsConfig crystals = new CrystalsConfig();
        public VegetationConfig vegetation = new VegetationConfig();

        public static class VegetationConfig {
            public ConfigBoolean controlVegetation = new ConfigBoolean(false);
            public ConfigBoolean biomeAllowList = new ConfigBoolean(false);
            public ConfigValue<String[]> biomeList = new ConfigValue<String[]>(new String[0]);
            public ConfigBoolean dimAllowList = new ConfigBoolean(false);
            public ConfigValue<String[]> dimList = new ConfigValue<String[]>(new String[0]);
        }

        public static class CrystalsConfig {
            public ConfigBoolean controlCrystals = new ConfigBoolean(false);
            public ConfigBoolean biomeAllowList = new ConfigBoolean(false);
            public ConfigValue<String[]> biomeList = new ConfigValue<String[]>(new String[0]);
            public ConfigBoolean dimAllowList = new ConfigBoolean(false);
            public ConfigValue<String[]> dimList = new ConfigValue<String[]>(new String[0]);
        }

        public static class AuraConfig {
            public ConfigBoolean controlAura = new ConfigBoolean(false);
            public ConfigBoolean biomeAllowList = new ConfigBoolean(false);
            public ConfigValue<String[]> biomeList = new ConfigValue<String[]>(new String[0]);
            public ConfigBoolean dimAllowList = new ConfigBoolean(false);
            public ConfigValue<String[]> dimList = new ConfigValue<String[]>(new String[0]);
        }
    }

    public static class ItemConfig {
        public ConfigBoolean primordialPearlDamageFix = new ConfigBoolean(true);
    }

    public static class ConfigBoolean {
        private OptionalInt forcedValue = OptionalInt.empty();
        private boolean value;

        public ConfigBoolean(boolean initialValue) {
            this.value = initialValue;
        }

        public boolean value() {
            if (this.forcedValue.isPresent()) {
                return this.forcedValue.getAsInt() == 1;
            }
            return this.value;
        }

        public boolean userValue() {
            return this.value;
        }

        public void setUserValue(boolean val) {
            this.value = val;
        }

        public void setSessionValue(boolean val) {
            this.forcedValue = OptionalInt.of(val ? 1 : 0);
        }

        public void unsetSessionValue() {
            this.forcedValue = OptionalInt.empty();
        }
    }

    public static class ConfigValue<T> {
        private Optional<T> forcedValue = Optional.empty();
        private T value;

        public ConfigValue(T initialValue) {
            this.value = initialValue;
        }

        public T value() {
            return this.forcedValue.orElse(this.value);
        }

        public T userValue() {
            return this.value;
        }

        public void setUserValue(T val) {
            this.value = val;
        }

        public void setSessionValue(T val) {
            this.forcedValue = Optional.of(val);
        }

        public void unsetSessionValue() {
            this.forcedValue = Optional.empty();
        }
    }
}

