/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.event;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.common.lib.research.ResearchManager;
import thecodex6824.thaumcraftfix.common.research.AdvancementResearchInfo;

@Mod.EventBusSubscriber(modid="thaumcraftfix")
public class AdvancementResearchEventHandler {
    protected static Map<ResourceLocation, AdvancementResearchInfo> advancements = new HashMap<ResourceLocation, AdvancementResearchInfo>();

    public static void addAdvancementInfo(ResourceLocation key, AdvancementResearchInfo info) {
        advancements.put(key, info);
    }

    public static void clearAdvancementInfo() {
        advancements.clear();
    }

    protected static void processResearchDeep(ResearchEntry initial, Predicate<ResearchEntry> accept, Function<ResearchEntry, String[]> nextLevel, Consumer<String> func) {
        ArrayDeque<String> researchStack = new ArrayDeque<String>();
        ArrayDeque<String> toVisit = new ArrayDeque<String>();
        HashSet<String> visited = new HashSet<String>();
        for (String s : nextLevel.apply(initial)) {
            toVisit.add(s);
            researchStack.push(s);
        }
        while (!toVisit.isEmpty()) {
            ResearchEntry entry;
            String s = (String)toVisit.poll();
            if (!visited.add(s) || (entry = ResearchCategories.getResearch((String)s)) == null || !accept.test(entry)) continue;
            for (String s2 : nextLevel.apply(entry)) {
                toVisit.add(s2);
                researchStack.push(s2);
            }
        }
        researchStack.forEach(func);
    }

    protected static void giveResearchFully(EntityPlayer player, IPlayerKnowledge knowledge, String key) {
        knowledge.addResearch(key);
        ResearchEntry entry = ResearchCategories.getResearch((String)key);
        if (entry != null) {
            if (entry.getStages() != null) {
                for (ResearchStage stage : entry.getStages()) {
                    if (stage.getResearch() == null) continue;
                    for (String s : stage.getResearch()) {
                        ResearchManager.completeResearch((EntityPlayer)player, (String)s, (boolean)true);
                    }
                }
            }
            ResearchManager.completeResearch((EntityPlayer)player, (String)key, (boolean)true);
            knowledge.setResearchFlag(key, IPlayerKnowledge.EnumResearchFlag.POPUP);
            knowledge.setResearchFlag(key, IPlayerKnowledge.EnumResearchFlag.PAGE);
        }
    }

    protected static boolean giveResearch(EntityPlayer player, IPlayerKnowledge knowledge, String key) {
        String researchWithoutStage = key;
        int stage = -1;
        if (researchWithoutStage.contains("@")) {
            String[] components = key.split("@", 2);
            researchWithoutStage = components[0];
            if (components.length == 2) {
                stage = MathHelper.func_82715_a((String)components[1], (int)0);
            }
        }
        if (!knowledge.isResearchKnown(researchWithoutStage) || !knowledge.isResearchComplete(researchWithoutStage)) {
            ResearchEntry entry = ResearchCategories.getResearch((String)researchWithoutStage);
            if (stage >= 1 && (entry == null || stage < entry.getStages().length)) {
                if (!knowledge.isResearchKnown(researchWithoutStage) || stage > knowledge.getResearchStage(researchWithoutStage)) {
                    if (entry != null && entry.getParents() != null && !knowledge.isResearchKnown(researchWithoutStage)) {
                        AdvancementResearchEventHandler.processResearchDeep(entry, e -> !knowledge.isResearchKnown(e.getKey()), e -> e.getParentsStripped(), s -> AdvancementResearchEventHandler.giveResearchFully(player, knowledge, s));
                    }
                    knowledge.addResearch(researchWithoutStage);
                    knowledge.setResearchStage(researchWithoutStage, stage);
                    return true;
                }
            } else {
                if (entry != null && entry.getParents() != null && !knowledge.isResearchComplete(researchWithoutStage)) {
                    AdvancementResearchEventHandler.processResearchDeep(entry, e -> !knowledge.isResearchKnown(e.getKey()), e -> e.getParentsStripped(), s -> AdvancementResearchEventHandler.giveResearchFully(player, knowledge, s));
                }
                AdvancementResearchEventHandler.giveResearchFully(player, knowledge, researchWithoutStage);
                if (entry != null && entry.getSiblings() != null) {
                    AdvancementResearchEventHandler.processResearchDeep(entry, e -> !knowledge.isResearchKnown(e.getKey()), e -> e.getSiblings(), s -> AdvancementResearchEventHandler.giveResearchFully(player, knowledge, s));
                }
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        AdvancementResearchInfo info;
        EntityPlayer player = event.getEntityPlayer();
        IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player);
        if (knowledge != null && (info = advancements.get(event.getAdvancement().func_192067_g())) != null) {
            if (!info.getResearchKeys().isEmpty()) {
                boolean didSomething = false;
                for (String s : info.getResearchKeys()) {
                    didSomething |= AdvancementResearchEventHandler.giveResearch(player, knowledge, s);
                }
                if (didSomething && player instanceof EntityPlayerMP) {
                    knowledge.sync((EntityPlayerMP)player);
                }
            }
            if (info.getResearchMessage().isPresent()) {
                player.func_146105_b(new TextComponentTranslation(info.getResearchMessage().get(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
            }
        }
    }
}

