/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.common.research;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ScanningManager;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.api.ResearchApi;
import thecodex6824.thaumcraftfix.common.event.AdvancementResearchEventHandler;
import thecodex6824.thaumcraftfix.common.json.JsonSchemaException;
import thecodex6824.thaumcraftfix.common.json.JsonUtils;
import thecodex6824.thaumcraftfix.common.research.AdvancementResearchInfo;

public final class ResearchConfigParser {
    private ResearchConfigParser() {
    }

    public static boolean loadCategories() {
        boolean researchErrors = false;
        Logger log = ThaumcraftFix.instance.getLogger();
        JsonParser parser = new JsonParser();
        File cats = new File("config/tcresearchpatcher", "categories.json");
        if (cats.isFile()) {
            try (FileInputStream s = new FileInputStream(cats);){
                String content = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8);
                JsonElement element = parser.parse(content);
                List<JsonObject> objects = JsonUtils.getObjectOrArrayContainedObjects(element);
                for (JsonObject o : objects) {
                    JsonPrimitive key = JsonUtils.getPrimitiveOrThrow("key", o);
                    JsonPrimitive requirement = JsonUtils.getPrimitiveOrThrow("requirement", o);
                    AspectList list = new AspectList();
                    JsonObject aspects = (JsonObject)JsonUtils.tryGetObject("aspects", o).or((Object)new JsonObject());
                    for (Map.Entry pair : aspects.entrySet()) {
                        if (!((JsonElement)pair.getValue()).isJsonPrimitive()) continue;
                        Aspect aspect = Aspect.getAspect((String)((String)pair.getKey()));
                        if (aspect == null) {
                            throw new JsonSchemaException(aspects + ": Invalid aspect entry: invalid aspect tag");
                        }
                        int amount = -1;
                        try {
                            amount = ((JsonElement)pair.getValue()).getAsInt();
                        }
                        catch (ClassCastException ex) {
                            throw new JsonSchemaException(aspects + ": Invalid aspect entry: invalid amount");
                        }
                        if (amount <= 0) continue;
                        list.add(aspect, amount);
                    }
                    JsonPrimitive icon = JsonUtils.getPrimitiveOrThrow("icon", o);
                    JsonPrimitive background = JsonUtils.getPrimitiveOrThrow("background", o);
                    JsonPrimitive backgroundOverlay = JsonUtils.getPrimitiveOrThrow("backgroundOverlay", o);
                    ResearchCategories.registerCategory((String)key.getAsString(), (String)requirement.getAsString(), (AspectList)list, (ResourceLocation)new ResourceLocation(icon.getAsString()), (ResourceLocation)new ResourceLocation(background.getAsString()), (ResourceLocation)new ResourceLocation(backgroundOverlay.getAsString()));
                }
            }
            catch (Exception ex) {
                log.error("categories.json: Error reading file: " + ex.getMessage());
                for (Throwable t : ex.getSuppressed()) {
                    log.error("Suppressed error: " + t.getMessage());
                }
                researchErrors = true;
            }
        }
        return researchErrors;
    }

    public static boolean loadScans() {
        boolean researchErrors = false;
        Logger log = ThaumcraftFix.instance.getLogger();
        JsonParser parser = new JsonParser();
        File scans = new File("config/tcresearchpatcher", "scans");
        if (scans.isDirectory()) {
            File[] files;
            for (File f : files = scans.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".json");
                }
            })) {
                try {
                    Throwable[] throwableArray = null;
                    try (FileInputStream s = new FileInputStream(f);){
                        String content = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8);
                        JsonElement element = parser.parse(content);
                        List<JsonObject> objects = JsonUtils.getObjectOrArrayContainedObjects(element);
                        int scanKeys = 0;
                        int totalScans = 0;
                        for (JsonObject o : objects) {
                            String key = JsonUtils.getPrimitiveOrThrow("key", o).getAsString();
                            ResourceLocation type = new ResourceLocation(JsonUtils.getPrimitiveOrThrow("type", o).getAsString());
                            JsonElement obj = JsonUtils.getOrThrow("object", o);
                            for (IScanThing thing : ResearchApi.parseScans(key, type, obj)) {
                                ScanningManager.addScannableThing((IScanThing)thing);
                                ++totalScans;
                            }
                            ++scanKeys;
                        }
                        log.info("scans/" + f.getName() + ": loaded " + scanKeys + " scan keys with " + totalScans + " scan entries");
                    }
                    catch (Throwable object) {
                        throwableArray = object;
                        throw object;
                    }
                }
                catch (Exception ex) {
                    log.error("scans/" + f.getName() + ": Error reading file: " + ex.getMessage());
                    for (Throwable t : ex.getSuppressed()) {
                        log.error("Suppressed error: " + t.getMessage());
                    }
                    researchErrors = true;
                }
            }
        }
        return researchErrors;
    }

    public static boolean loadAdvancements() {
        boolean researchErrors = false;
        Logger log = ThaumcraftFix.instance.getLogger();
        JsonParser parser = new JsonParser();
        File advancements = new File("config/tcresearchpatcher", "advancements");
        if (advancements.isDirectory()) {
            File[] files;
            for (File f : files = advancements.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isFile() && f.getName().endsWith(".json");
                }
            })) {
                try {
                    Throwable[] throwableArray = null;
                    try (FileInputStream s = new FileInputStream(f);){
                        String content = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8);
                        JsonElement element = parser.parse(content);
                        int total = 0;
                        for (JsonObject o : JsonUtils.getObjectOrArrayContainedObjects(element)) {
                            AdvancementResearchInfo info = new AdvancementResearchInfo(o);
                            AdvancementResearchEventHandler.addAdvancementInfo(info.getAdvancementKey(), info);
                            ++total;
                        }
                        log.info("advancements/" + f.getName() + ": loaded " + total + " advancement keys");
                    }
                    catch (Throwable object) {
                        throwableArray = object;
                        throw object;
                    }
                }
                catch (Exception ex) {
                    log.error("advancements/" + f.getName() + ": Error reading file: " + ex.getMessage());
                    for (Throwable t : ex.getSuppressed()) {
                        log.error("Suppressed error: " + t.getMessage());
                    }
                    researchErrors = true;
                }
            }
        }
        return researchErrors;
    }
}

