/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.common.container.ContainerFocalManipulator;
import thaumcraft.common.container.ContainerThaumatorium;
import thaumcraft.common.lib.network.misc.PacketLogisticsRequestToServer;
import thaumcraft.common.lib.network.misc.PacketNote;
import thaumcraft.common.lib.network.misc.PacketSelectThaumotoriumRecipeToServer;
import thaumcraft.common.lib.network.playerdata.PacketFocusNodesToServer;
import thaumcraft.common.tiles.crafting.TileFocalManipulator;
import thaumcraft.common.tiles.crafting.TileResearchTable;
import thecodex6824.coremodlib.FieldDefinition;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.ThaumcraftFix;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.Types;
import thecodex6824.thaumcraftfix.core.transformer.custom.PacketNoteHandlerRewriteTransformer;
import thecodex6824.thaumcraftfix.core.transformer.custom.ThrowingTransformerWrapper;

public class NetworkTransformers {
    private static final String HOOKS = Type.getInternalName(Hooks.class);
    public static final Supplier<ITransformer> FOCAL_MANIPULATOR_DATA = () -> {
        LabelNode newLabel = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/network/playerdata/PacketFocusNodesToServer$1", false, "run", Type.VOID_TYPE, new Type[0])).findAny()).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/common/lib/network/playerdata/PacketFocusNodesToServer$1", "val$message", Type.getType((String)"Lthaumcraft/common/lib/network/playerdata/PacketFocusNodesToServer;")).asFieldInsnNode(180), new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/common/lib/network/playerdata/PacketFocusNodesToServer$1", "val$ctx", Type.getType((String)"Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;")).asFieldInsnNode(180), new MethodInsnNode(184, HOOKS, "validateFocalManipulatorNodeData", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType((String)"Lthaumcraft/common/lib/network/playerdata/PacketFocusNodesToServer;"), Type.getType((String)"Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;")}), false), new JumpInsnNode(154, newLabel), new InsnNode(177), newLabel, new FrameNode(3, 0, null, 0, null)}).build(), true, 1);
    };
    public static final Supplier<ITransformer> LOGISTICS_REQUEST = () -> {
        LabelNode newLabel = new LabelNode(new Label());
        return new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/network/misc/PacketLogisticsRequestToServer$1", false, "run", Type.VOID_TYPE, new Type[0])).findAny()).insertInstructionsBefore(new AbstractInsnNode[]{new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/common/lib/network/misc/PacketLogisticsRequestToServer$1", "val$message", Type.getType((String)"Lthaumcraft/common/lib/network/misc/PacketLogisticsRequestToServer;")).asFieldInsnNode(180), new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/common/lib/network/misc/PacketLogisticsRequestToServer$1", "val$ctx", Type.getType((String)"Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;")).asFieldInsnNode(180), new MethodInsnNode(184, HOOKS, "validateLogisticsRequest", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType((String)"Lthaumcraft/common/lib/network/misc/PacketLogisticsRequestToServer;"), Type.getType((String)"Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;")}), false), new JumpInsnNode(154, newLabel), new InsnNode(177), newLabel, new FrameNode(3, 0, null, 0, null)}).build(), true, 1);
    };
    public static final Supplier<ITransformer> NOTE_HANDLER = () -> new ThrowingTransformerWrapper(new PacketNoteHandlerRewriteTransformer());
    public static final Supplier<ITransformer> RESEARCH_TABLE_AIDS = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/network/misc/PacketStartTheoryToServer$1", false, "run", Type.VOID_TYPE, new Type[0])).findNextMethodCall(new MethodDefinition("thaumcraft/common/lib/network/misc/PacketStartTheoryToServer", false, "access$100", Types.SET, Type.getType((String)"Lthaumcraft/common/lib/network/misc/PacketStartTheoryToServer;")))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 2), new VarInsnNode(25, 4), new MethodInsnNode(184, HOOKS, "filterResearchAids", Type.getMethodDescriptor((Type)Types.SET, (Type[])new Type[]{Types.SET, Types.ENTITY_PLAYER, Types.TILE_ENTITY}), false)}).build(), true, 1);
    public static final Supplier<ITransformer> THAUMATORIUM_RECIPE_SELECTION = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(new MethodDefinition("thaumcraft/common/lib/network/misc/PacketSelectThaumotoriumRecipeToServer$1", false, "run", Type.VOID_TYPE, new Type[0])).findNextInstanceOf(Types.ENTITY_PLAYER)).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/common/lib/network/misc/PacketSelectThaumotoriumRecipeToServer$1", "val$message", Type.getType((String)"Lthaumcraft/common/lib/network/misc/PacketSelectThaumotoriumRecipeToServer;")).asFieldInsnNode(180), new VarInsnNode(25, 0), new FieldDefinition("thaumcraft/common/lib/network/misc/PacketSelectThaumotoriumRecipeToServer$1", "val$ctx", Type.getType((String)"Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;")).asFieldInsnNode(180), new MethodInsnNode(184, HOOKS, "validateThaumatoriumSelection", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType((String)"Lthaumcraft/common/lib/network/misc/PacketSelectThaumotoriumRecipeToServer;"), Type.getType((String)"Lnet/minecraftforge/fml/common/network/simpleimpl/MessageContext;")}), false), new InsnNode(126)}).build(), true, 1);

    public static final class Hooks {
        private static Field logisticsRequestPosition;
        private static volatile Method originalPacketNoteHandle;
        private static Field packetNoteDim;
        private static Field packetNoteX;
        private static Field packetNoteY;
        private static Field packetNoteZ;
        private static Field thaumatoriumRecipePosition;
        private static Field containerThaumatoriumTile;
        private static Field focusNodesPosition;
        private static Field containerFocalManipulatorTile;

        private static boolean validatePosition(EntityPlayerMP player, BlockPos target, String component) {
            if (!player.func_130014_f_().func_175667_e(target)) {
                ThaumcraftFix.instance.getLogger().warn("Player {} ({}) sent {} for unloaded position {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)component, (Object)target.toString());
                return false;
            }
            Vec3d start = player.func_174824_e(1.0f);
            Vec3d end = new Vec3d((Vec3i)target).func_72441_c(0.5, 0.5, 0.5);
            double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() + 1.0;
            double distance = start.func_72436_e(end);
            if (distance > reach * reach) {
                ThaumcraftFix.instance.getLogger().warn("Player {} ({}) sent {} for a position too far away. Pos = {}, distance = {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)component, (Object)target.toString(), (Object)Math.sqrt(distance));
                return false;
            }
            return true;
        }

        public static boolean validateLogisticsRequest(PacketLogisticsRequestToServer message, MessageContext ctx) throws Exception {
            if (logisticsRequestPosition == null) {
                logisticsRequestPosition = PacketLogisticsRequestToServer.class.getDeclaredField("pos");
                logisticsRequestPosition.setAccessible(true);
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            boolean ok = player.func_70089_S();
            BlockPos pos = (BlockPos)logisticsRequestPosition.get(message);
            if (ok && pos != null) {
                ok = Hooks.validatePosition(player, pos, "logistics request");
            }
            return ok;
        }

        public static void handlePacketNote(PacketNote message, MessageContext ctx) throws Exception {
            if (originalPacketNoteHandle == null) {
                originalPacketNoteHandle = PacketNote.class.getMethod("onMessageOriginalRedirectedByTCFix", PacketNote.class, MessageContext.class);
            }
            ThaumcraftFix.proxy.scheduleTask(ctx.side, () -> {
                try {
                    boolean ok = true;
                    if (ctx.side == Side.SERVER) {
                        int dim;
                        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                        if (packetNoteDim == null) {
                            packetNoteDim = PacketNote.class.getDeclaredField("dim");
                            packetNoteDim.setAccessible(true);
                        }
                        if ((dim = packetNoteDim.getInt(message)) != player.field_71093_bK) {
                            ok = false;
                            ThaumcraftFix.instance.getLogger().warn("Player {} ({}) tried to get note status of a dimension they weren't in. Player dim = {}, requested dim = {}", (Object)player.func_70005_c_(), (Object)player.func_110124_au().toString(), (Object)player.field_71093_bK, (Object)dim);
                        }
                        if (ok) {
                            if (packetNoteX == null) {
                                packetNoteX = PacketNote.class.getDeclaredField("x");
                                packetNoteX.setAccessible(true);
                                packetNoteY = PacketNote.class.getDeclaredField("y");
                                packetNoteY.setAccessible(true);
                                packetNoteZ = PacketNote.class.getDeclaredField("z");
                                packetNoteZ.setAccessible(true);
                            }
                            BlockPos pos = new BlockPos(packetNoteX.getInt(message), packetNoteY.getInt(message), packetNoteZ.getInt(message));
                            ok = Hooks.validatePosition(player, pos, "note status");
                        }
                    }
                    if (ok) {
                        originalPacketNoteHandle.invoke((Object)message, message, ctx);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
        }

        public static boolean validateThaumatoriumSelection(PacketSelectThaumotoriumRecipeToServer message, MessageContext ctx) throws Exception {
            if (thaumatoriumRecipePosition == null) {
                thaumatoriumRecipePosition = PacketSelectThaumotoriumRecipeToServer.class.getDeclaredField("pos");
                thaumatoriumRecipePosition.setAccessible(true);
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            boolean ok = player.func_70089_S();
            BlockPos pos = BlockPos.func_177969_a((long)thaumatoriumRecipePosition.getLong(message));
            if (ok && pos != null && (ok = Hooks.validatePosition(player, pos, "thaumatorium recipe selection"))) {
                if (containerThaumatoriumTile == null) {
                    containerThaumatoriumTile = ContainerThaumatorium.class.getDeclaredField("thaumatorium");
                    containerThaumatoriumTile.setAccessible(true);
                }
                ok = player.field_71070_bA instanceof ContainerThaumatorium && ((TileEntity)containerThaumatoriumTile.get(player.field_71070_bA)).func_174877_v().equals((Object)pos);
            }
            return ok;
        }

        public static boolean validateFocalManipulatorNodeData(PacketFocusNodesToServer message, MessageContext ctx) throws Exception {
            if (focusNodesPosition == null) {
                focusNodesPosition = PacketFocusNodesToServer.class.getDeclaredField("loc");
                focusNodesPosition.setAccessible(true);
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            boolean ok = player.func_70089_S();
            BlockPos pos = BlockPos.func_177969_a((long)focusNodesPosition.getLong(message));
            if (ok && pos != null) {
                boolean bl = ok = Hooks.validatePosition(player, pos, "focal manipulator node selections") && player.field_71070_bA instanceof ContainerFocalManipulator;
                if (ok) {
                    TileFocalManipulator tile;
                    if (containerFocalManipulatorTile == null) {
                        containerFocalManipulatorTile = ContainerFocalManipulator.class.getDeclaredField("table");
                        containerFocalManipulatorTile.setAccessible(true);
                    }
                    ok = (tile = (TileFocalManipulator)containerFocalManipulatorTile.get(player.field_71070_bA)).func_174877_v().equals((Object)pos) && tile.vis <= 0.0f;
                }
            }
            return ok;
        }

        public static Set<String> filterResearchAids(Set<String> toFilter, EntityPlayer player, TileEntity table) {
            HashSet<String> ret = new HashSet<String>(toFilter);
            ret.retainAll(((TileResearchTable)table).checkSurroundingAids());
            return ret;
        }
    }
}

