/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.common.container.ContainerFocalManipulator;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.coremodlib.PatchBuilders;
import thecodex6824.coremodlib.PatchStateMachine;
import thecodex6824.thaumcraftfix.core.transformer.GenericStateMachineTransformer;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.TransformUtil;
import thecodex6824.thaumcraftfix.core.transformer.Types;

public class SoundTransformers {
    private static final String HOOKS = Type.getInternalName(Hooks.class);
    public static final Supplier<ITransformer> SOUND_FIX_CASTER_TICK = SoundTransformers.makeSoundFixupTransformer(new MethodDefinition("thaumcraft/common/items/casters/CasterManager", false, "changeFocus", Type.VOID_TYPE, Types.ITEM_STACK, Types.WORLD, Types.ENTITY_PLAYER, Types.STRING), Types.ENTITY_PLAYER, 2);
    public static final Supplier<ITransformer> SOUND_FIX_FOCAL_MANIPULATOR_CONTAINER = () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)PatchStateMachine.builder(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/container/ContainerFocalManipulator", false, "func_75140_a", Type.BOOLEAN_TYPE, Types.ENTITY_PLAYER, Type.INT_TYPE))).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(Types.WORLD.getInternalName(), false, "func_184133_a", Type.VOID_TYPE, Types.ENTITY_PLAYER, Types.BLOCK_POS, Types.SOUND_EVENT, Type.getType((String)"Lnet/minecraft/util/SoundCategory;"), Type.FLOAT_TYPE, Type.FLOAT_TYPE)))).insertInstructionsAfter(new AbstractInsnNode[]{new VarInsnNode(25, 1), new MethodInsnNode(184, HOOKS, "fixupFocalManipulatorCraftFail", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Types.ENTITY_PLAYER}), false)}).build());
    public static final Supplier<ITransformer> SOUND_FIX_LOOT_BAG = SoundTransformers.makeSoundFixupTransformer(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/items/curios/ItemLootBag", false, "func_77659_a", Type.getType((String)"Lnet/minecraft/util/ActionResult;"), Types.WORLD, Types.ENTITY_PLAYER, Types.ENUM_HAND)), Types.ENTITY_PLAYER, 2);
    public static final Supplier<ITransformer> SOUND_FIX_PHIAL_FILL = SoundTransformers.makeSoundFixupTransformer(new MethodDefinition("thaumcraft/common/items/consumables/ItemPhial", false, "onItemUseFirst", Type.getType((String)"Lnet/minecraft/util/EnumActionResult;"), Types.ENTITY_PLAYER, Types.WORLD, Types.BLOCK_POS, Types.ENUM_FACING, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Types.ENUM_HAND), Types.ENTITY_PLAYER, 1);
    public static final Supplier<ITransformer> SOUND_FIX_JAR_FILL = SoundTransformers.makeSoundFixupTransformer(new MethodDefinition("thaumcraft/common/blocks/essentia/BlockJarItem", false, "onItemUseFirst", Type.getType((String)"Lnet/minecraft/util/EnumActionResult;"), Types.ENTITY_PLAYER, Types.WORLD, Types.BLOCK_POS, Types.ENUM_FACING, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Types.ENUM_HAND), Types.ENTITY_PLAYER, 1);
    public static final Supplier<ITransformer> SOUND_FIX_WIND_SWORD_USE = SoundTransformers.makeSoundFixupTransformer(new MethodDefinition("thaumcraft/common/items/tools/ItemElementalSword", false, "onUsingTick", Type.VOID_TYPE, Types.ITEM_STACK, Types.ENTITY_LIVING_BASE, Type.INT_TYPE), Types.ENTITY_LIVING_BASE, 2);
    public static final Supplier<ITransformer> SOUND_FIX_MIRROR_USE = SoundTransformers.makeSoundFixupTransformer(TransformUtil.remapMethod(new MethodDefinition("thaumcraft/common/items/tools/ItemHandMirror", false, "func_77659_a", Type.getType((String)"Lnet/minecraft/util/ActionResult;"), Types.WORLD, Types.ENTITY_PLAYER, Types.ENUM_HAND)), Types.ENTITY_PLAYER, 2);
    public static final Supplier<ITransformer> SOUND_FIX_MIRROR_TRANSPORT = SoundTransformers.makeSoundFixupTransformer(new MethodDefinition("thaumcraft/common/items/tools/ItemHandMirror", false, "transport", Type.BOOLEAN_TYPE, Types.ITEM_STACK, Types.ITEM_STACK, Types.ENTITY_PLAYER, Types.WORLD), Types.ENTITY_PLAYER, 2);

    private static Supplier<ITransformer> makeSoundFixupTransformer(MethodDefinition target, Type playerType, int playerIndex) {
        return () -> new GenericStateMachineTransformer(((PatchBuilders.TransformerBuilder)((PatchBuilders.ConsecutiveMatchBuilder)((PatchBuilders.ConsecutiveMatchBuilder)PatchStateMachine.builder(target).findConsecutive().findNextLocalAccess(playerIndex)).findNextFieldAccessOfType(Types.SOUND_EVENT)).endConsecutive().insertInstructionsAfter(new AbstractInsnNode[]{new InsnNode(92)}).findNextMethodCall(TransformUtil.remapMethod(new MethodDefinition(playerType.getInternalName(), false, "func_184185_a", Type.VOID_TYPE, Types.SOUND_EVENT, Type.FLOAT_TYPE, Type.FLOAT_TYPE)))).insertInstructionsBefore(new AbstractInsnNode[]{new InsnNode(94), new MethodInsnNode(184, HOOKS, "fixupPlayerSound", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Types.ENTITY_LIVING_BASE, Types.SOUND_EVENT, Type.FLOAT_TYPE, Type.FLOAT_TYPE}), false)}).build());
    }

    public static final class Hooks {
        private static Field containerFocalManipulatorTile;

        public static void fixupPlayerSound(EntityLivingBase player, SoundEvent sound, float volume, float pitch) {
            if (player instanceof EntityPlayerMP) {
                SPacketSoundEffect packet = new SPacketSoundEffect(sound, player.func_184176_by(), player.field_70165_t, player.field_70163_u, player.field_70161_v, volume, pitch);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
            }
        }

        public static void fixupFocalManipulatorCraftFail(EntityPlayer player) throws Exception {
            if (player instanceof EntityPlayerMP) {
                if (containerFocalManipulatorTile == null) {
                    containerFocalManipulatorTile = ContainerFocalManipulator.class.getDeclaredField("table");
                    containerFocalManipulatorTile.setAccessible(true);
                }
                TileEntity tile = (TileEntity)containerFocalManipulatorTile.get(player.field_71070_bA);
                BlockPos pos = tile.func_174877_v();
                SPacketSoundEffect sound = new SPacketSoundEffect(SoundsTC.craftfail, SoundCategory.BLOCKS, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.33f, 1.0f);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)sound);
            }
        }
    }
}

