/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.core.transformer.custom;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import thecodex6824.coremodlib.MethodDefinition;
import thecodex6824.thaumcraftfix.core.transformer.ITransformer;
import thecodex6824.thaumcraftfix.core.transformer.TransformUtil;

public class ChangeVariableTypeTransformer
implements ITransformer {
    private final MethodDefinition def;
    private final String classWithDots;
    private final Type from;
    private final Type to;
    private final boolean itf;
    private final boolean ignoreNew;
    private final Set<String> ignored;

    public ChangeVariableTypeTransformer(MethodDefinition target, Type fromType, Type toType, boolean toIsInterface) {
        this(target, fromType, toType, toIsInterface, Collections.emptyList(), false);
    }

    public ChangeVariableTypeTransformer(MethodDefinition target, Type fromType, Type toType, boolean toIsInterface, Collection<String> ignoreMethods, boolean ignoreInstantiation) {
        this.def = target;
        this.classWithDots = target.declaringClass().replace("/", ".");
        this.from = fromType;
        this.to = toType;
        this.itf = toIsInterface;
        this.ignored = ImmutableSet.copyOf(ignoreMethods);
        this.ignoreNew = ignoreInstantiation;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return this.classWithDots.equals(transformedName);
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        MethodNode method = TransformUtil.findMethod(classNode, this.def);
        boolean didSomething = false;
        for (int i = 0; i < method.instructions.size(); ++i) {
            int var;
            AbstractInsnNode node = method.instructions.get(i);
            if (node instanceof TypeInsnNode && (!this.ignoreNew || node.getOpcode() != 187)) {
                TypeInsnNode typeNode = (TypeInsnNode)node;
                if (!typeNode.desc.equals(this.from.getInternalName())) continue;
                typeNode.desc = this.to.getInternalName();
                didSomething = true;
                continue;
            }
            if (node instanceof MethodInsnNode && (!this.ignoreNew || node.getOpcode() != 183)) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                if (this.ignored.contains(methodNode.name) || !methodNode.owner.equals(this.from.getInternalName())) continue;
                methodNode.owner = this.to.getInternalName();
                methodNode.itf = this.itf;
                if (node.getOpcode() != 183) {
                    methodNode.setOpcode(this.itf ? 185 : 182);
                }
                didSomething = true;
                continue;
            }
            if (node instanceof FieldInsnNode) {
                FieldInsnNode field = (FieldInsnNode)node;
                if (!field.owner.equals(this.from.getInternalName())) continue;
                field.owner = this.to.getInternalName();
                didSomething = true;
                continue;
            }
            if (!(node instanceof FrameNode)) continue;
            FrameNode frame = (FrameNode)node;
            if (frame.stack != null) {
                for (var = 0; var < frame.stack.size(); ++var) {
                    if (!this.from.getInternalName().equals(frame.stack.get(var))) continue;
                    frame.stack.set(var, this.to.getInternalName());
                    didSomething = true;
                }
            }
            if (frame.local == null) continue;
            for (var = 0; var < frame.local.size(); ++var) {
                if (!this.from.getInternalName().equals(frame.local.get(var))) continue;
                frame.local.set(var, this.to.getInternalName());
                didSomething = true;
            }
        }
        return didSomething;
    }
}

