/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumcraftfix.mixin.event;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import thaumcraft.common.lib.events.ToolEvents;

@Mixin(value={ToolEvents.class})
public class ToolEventsMixin {
    private static final ThreadLocal<Boolean> processingBurrowing = ThreadLocal.withInitial(() -> false);

    @ModifyExpressionValue(method={"breakBlockEvent(Lnet/minecraftforge/event/world/BlockEvent$BreakEvent;)V"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;isToolEffective(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/item/ItemStack;)Z", remap=false)}, remap=false)
    private static boolean isToolEffectiveForBurrowing(boolean original, BlockEvent.BreakEvent event) {
        if (original) {
            return true;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        return state.func_177230_c().getHarvestTool(state) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"breakBlockEvent(Lnet/minecraftforge/event/world/BlockEvent$BreakEvent;)V"}, at={@At(value="INVOKE", target="isValidBurrowBlock(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", remap=false)}, remap=false)
    private static boolean wrapIsValidBurrowBlock(World world, BlockPos pos, Operation<Boolean> original) {
        if (!processingBurrowing.get().booleanValue()) {
            processingBurrowing.set(true);
            boolean result = false;
            try {
                result = (Boolean)original.call(new Object[]{world, pos});
            }
            finally {
                if (!result) {
                    processingBurrowing.set(false);
                }
            }
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"breakBlockEvent(Lnet/minecraftforge/event/world/BlockEvent$BreakEvent;)V"}, at={@At(value="INVOKE", target="Lthaumcraft/common/lib/utils/BlockUtils;breakFurthestBlock(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/player/EntityPlayer;)Z", remap=false)}, remap=false)
    private static boolean wrapBreakFurthestBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, Operation<Boolean> original) {
        boolean result = false;
        try {
            result = (Boolean)original.call(new Object[]{world, pos, state, player});
        }
        finally {
            processingBurrowing.set(false);
        }
        return result;
    }
}

