/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.IErrorLogic;
import forestry.core.blocks.BlockBase;
import forestry.core.errors.EnumErrorCode;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TemperatureState;
import forestry.core.tiles.TileBase;
import forestry.core.utils.NetworkUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.energy.EnergyTransferMode;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEngine
extends TileBase
implements IActivatable,
IStreamableGui {
    private static final int CANT_SEND_ENERGY_TIME = 20;
    private boolean active = false;
    private int cantSendEnergyCountdown = 20;
    public int stagePiston = 0;
    public float pistonSpeedServer = 0.0f;
    protected int currentOutput = 0;
    protected int heat;
    protected final int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;
    protected final EnergyManager energyManager;
    private final String hintKey;

    protected TileEngine(String hintKey, int maxHeat, int maxEnergy) {
        this.hintKey = hintKey;
        this.maxHeat = maxHeat;
        this.energyManager = new EnergyManager(2000, maxEnergy);
        this.energyManager.setExternalMode(EnergyTransferMode.EXTRACT);
        this.energyManager.setChangeHandler(energy -> {
            if (this.field_145850_b != null) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            }
        });
    }

    public String getHintKey() {
        return this.hintKey;
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    protected abstract int dissipateHeat();

    protected abstract int generateHeat();

    protected boolean mayBurn() {
        return !this.forceCooldown;
    }

    protected abstract void burn();

    @Override
    public void updateClientSide() {
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if (this.progress > 1.0f) {
                this.stagePiston = 0;
                this.progress = 0.0f;
            }
        } else if (this.active) {
            this.stagePiston = 1;
        }
    }

    @Override
    protected void updateServerSide() {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(this.forceCooldown, EnumErrorCode.FORCED_COOLDOWN);
        boolean enabledRedstone = this.isRedstoneActivated();
        errorLogic.setCondition(!enabledRedstone, EnumErrorCode.NO_REDSTONE);
        IBlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)blockState.func_177229_b(BlockBase.FACING);
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
        float newPistonSpeed = this.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.setNeedsNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            EnergyHelper.sendEnergy(this.energyManager, facing, tile);
            if ((double)this.progress > 0.25 && this.stagePiston == 1) {
                this.stagePiston = 2;
            } else if ((double)this.progress >= 0.5) {
                this.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (enabledRedstone && EnergyHelper.isEnergyReceiverOrEngine(facing.func_176734_d(), tile)) {
            if (EnergyHelper.canSendEnergy(this.energyManager, facing, tile)) {
                this.stagePiston = 1;
                this.setActive(true);
                this.cantSendEnergyCountdown = 20;
            } else if (this.isActive()) {
                --this.cantSendEnergyCountdown;
                if (this.cantSendEnergyCountdown <= 0) {
                    this.setActive(false);
                }
            }
        } else {
            this.setActive(false);
        }
        this.dissipateHeat();
        this.generateHeat();
        if (this.mayBurn()) {
            this.burn();
        } else {
            this.energyManager.drainEnergy(20);
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.field_145850_b.field_72995_K) {
            NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.field_174879_c, this.field_145850_b);
        }
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    protected abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.isRedstoneActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public int getHeat() {
        return this.heat;
    }

    public TemperatureState getTemperatureState() {
        return TemperatureState.getState(this.heat, this.maxHeat);
    }

    protected float getPistonSpeed() {
        switch (this.getTemperatureState()) {
            case COOL: {
                return 0.03f;
            }
            case WARMED_UP: {
                return 0.04f;
            }
            case OPERATING_TEMPERATURE: {
                return 0.05f;
            }
            case RUNNING_HOT: {
                return 0.06f;
            }
            case OVERHEATING: {
                return 0.07f;
            }
            case MELTING: {
                return 0.08f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyManager.readFromNBT(nbt);
        this.heat = nbt.func_74762_e("EngineHeat");
        this.progress = nbt.func_74760_g("EngineProgress");
        this.forceCooldown = nbt.func_74767_n("ForceCooldown");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.energyManager.writeToNBT(nbt);
        nbt.func_74768_a("EngineHeat", this.heat);
        nbt.func_74776_a("EngineProgress", this.progress);
        nbt.func_74757_a("ForceCooldown", this.forceCooldown);
        return nbt;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        data.writeBoolean(this.active);
        data.writeInt(this.heat);
        data.writeFloat(this.pistonSpeedServer);
        this.energyManager.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.active = data.readBoolean();
        this.heat = data.readInt();
        this.pistonSpeedServer = data.readFloat();
        this.energyManager.readData(data);
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        data.writeInt(this.currentOutput);
        data.writeInt(this.heat);
        data.writeBoolean(this.forceCooldown);
        this.energyManager.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        this.currentOutput = data.readInt();
        this.heat = data.readInt();
        this.forceCooldown = data.readBoolean();
        this.energyManager.readData(data);
    }

    public EnergyManager getEnergyManager() {
        return this.energyManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return facing == this.getFacing() && this.energyManager.hasCapability(capability) || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T energyCapability;
        if (facing == this.getFacing() && (energyCapability = this.energyManager.getCapability(capability)) != null) {
            return energyCapability;
        }
        return super.getCapability(capability, facing);
    }
}

