/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class AdvancedExplosion
extends Explosion {
    protected static final Random rand = new Random();
    public final World worldObj;
    public final double explosionX;
    public final double explosionY;
    public final double explosionZ;
    public final Entity exploder;
    public final float explosionSize;
    protected boolean blocksCalculated;

    public AdvancedExplosion(World world, Entity entity, double x, double y, double z, float size, boolean flame, boolean smoke) {
        super(world, entity, x, y, z, size, flame, smoke);
        this.worldObj = world;
        this.exploder = entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = size;
    }

    public void setAffectedBlockPositions(List<BlockPos> list) {
        this.func_180343_e().addAll(list);
        this.blocksCalculated = true;
    }

    public void doEntityExplosion() {
        this.doEntityExplosion(DamageSource.func_94539_a((Explosion)this));
    }

    public void doEntityExplosion(DamageSource damagesource) {
        float size = this.explosionSize * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)size - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)size + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)size - 1.0));
        int i3 = MathHelper.func_76128_c((double)(this.explosionY + (double)size + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)size - 1.0));
        int j3 = MathHelper.func_76128_c((double)(this.explosionZ + (double)size + 1.0));
        List list = this.worldObj.func_72839_b(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i3, (double)j3));
        Vec3d vec31 = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        for (Entity entity : list) {
            double dz;
            double dy;
            double dx;
            double d;
            double dr;
            if (entity.func_180427_aV() || !((dr = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)size) <= 1.0) || (d = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - this.explosionX) * dx + (dy = entity.field_70163_u - this.explosionY) * dy + (dz = entity.field_70161_v - this.explosionZ) * dz))) == 0.0) continue;
            dx /= d;
            dy /= d;
            dz /= d;
            double dens = this.worldObj.func_72842_a(vec31, entity.func_174813_aQ());
            double var36 = (1.0 - dr) * dens;
            int damage = (int)((var36 * var36 + var36) / 2.0 * 8.0 * (double)size + 1.0);
            entity.func_70097_a(damagesource, (float)damage);
            entity.field_70159_w += dx * var36;
            entity.field_70181_x += dy * var36;
            entity.field_70179_y += dz * var36;
        }
    }

    public void doBlockExplosion() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.func_180343_e()) {
            if (this.worldObj.func_175623_d(blockpos)) continue;
            IBlockState iblockstate = this.worldObj.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (block.func_149659_a((Explosion)this)) {
                block.func_180653_a(this.worldObj, blockpos, iblockstate, 1.0f / this.explosionSize, 0);
            }
            this.worldObj.func_175698_g(blockpos);
            block.onBlockExploded(this.worldObj, blockpos, (Explosion)this);
        }
    }

    public void doFlaming() {
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.func_180343_e()) {
            if (!this.worldObj.func_175623_d(blockpos) || !this.worldObj.func_180495_p(blockpos.func_177977_b()).func_185913_b() || rand.nextInt(3) != 0) continue;
            this.worldObj.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public void doParticleExplosion(boolean smallparticles, boolean bigparticles) {
        this.worldObj.func_184148_a(null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (bigparticles) {
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!smallparticles) {
            return;
        }
        if (!this.blocksCalculated) {
            this.calculateBlockExplosion();
        }
        for (BlockPos blockpos : this.func_180343_e()) {
            double px = (float)blockpos.func_177958_n() + this.worldObj.field_73012_v.nextFloat();
            double py = (float)blockpos.func_177956_o() + this.worldObj.field_73012_v.nextFloat();
            double pz = (float)blockpos.func_177952_p() + this.worldObj.field_73012_v.nextFloat();
            double dx = px - this.explosionX;
            double dy = py - this.explosionY;
            double dz = pz - this.explosionZ;
            double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
            dx /= distance;
            dy /= distance;
            dz /= distance;
            double d7 = 0.5 / (distance / (double)this.explosionSize + 0.1);
            this.worldObj.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (px + this.explosionX) / 2.0, (py + this.explosionY) / 2.0, (pz + this.explosionZ) / 2.0, dx *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f)), dy *= d7, dz *= d7, new int[0]);
            this.worldObj.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, py, pz, dx, dy, dz, new int[0]);
        }
    }

    protected void calculateBlockExplosion() {
        int maxsize = 16;
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < maxsize; ++j) {
            for (int k = 0; k < maxsize; ++k) {
                for (int l = 0; l < maxsize; ++l) {
                    if (j != 0 && j != maxsize - 1 && k != 0 && k != maxsize - 1 && l != 0 && l != maxsize - 1) continue;
                    double rx = (float)j / 15.0f * 2.0f - 1.0f;
                    double ry = (float)k / 15.0f * 2.0f - 1.0f;
                    double rz = (float)l / 15.0f * 2.0f - 1.0f;
                    double rd = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    rx /= rd;
                    ry /= rd;
                    rz /= rd;
                    double dx = this.explosionX;
                    double dy = this.explosionY;
                    double dz = this.explosionZ;
                    float f = 0.3f;
                    for (float strength = this.explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); strength > 0.0f; strength -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(dx, dy, dz);
                        if (!this.worldObj.func_175623_d(blockpos)) {
                            IBlockState iblockstate = this.worldObj.func_180495_p(blockpos);
                            strength -= (iblockstate.func_177230_c().getExplosionResistance(this.worldObj, blockpos, this.exploder, (Explosion)this) + 0.3f) * f;
                        }
                        if (strength > 0.0f) {
                            set.add(blockpos);
                        }
                        dx += rx * 0.3;
                        dy += ry * 0.3;
                        dz += rz * 0.3;
                    }
                }
            }
        }
        this.func_180343_e().addAll(set);
        this.blocksCalculated = true;
    }
}

