/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod;

import ckathode.weaponmod.BalkonsWeaponMod;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;

public final class PlayerWeaponData {
    private static final DataParameter<Integer> WARHAMMER_LAST_SMASH_TICKS = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FLAIL_THROWN = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FLAIL_ENTITY_ID = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPlayerWeaponData(EntityPlayer player) {
        String playername = PlayerWeaponData.getPlayerName(player);
        BalkonsWeaponMod.modLog.trace("Initializing DataManager values for {}", (Object)playername);
        EntityDataManager dataManager = player.func_184212_Q();
        try {
            dataManager.func_187225_a(WARHAMMER_LAST_SMASH_TICKS);
            BalkonsWeaponMod.modLog.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)WARHAMMER_LAST_SMASH_TICKS.func_187155_a());
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataManager.func_187214_a(WARHAMMER_LAST_SMASH_TICKS, (Object)player.field_70173_aa);
        }
        try {
            dataManager.func_187225_a(FLAIL_THROWN);
            BalkonsWeaponMod.modLog.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)FLAIL_THROWN.func_187155_a());
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataManager.func_187214_a(FLAIL_THROWN, (Object)false);
        }
        try {
            dataManager.func_187225_a(FLAIL_ENTITY_ID);
            BalkonsWeaponMod.modLog.warn("DataManager ID conflict for {} @ {}", (Object)playername, (Object)FLAIL_ENTITY_ID.func_187155_a());
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            dataManager.func_187214_a(FLAIL_ENTITY_ID, (Object)0);
        }
    }

    private static String getPlayerName(EntityPlayer player) {
        String playername = player.func_146103_bH() != null ? player.func_146103_bH().getName() : "[unknown]";
        return "player:" + playername;
    }

    private static void unavailableError(EntityPlayer player, int id) {
        BalkonsWeaponMod.modLog.error("DataManager ID {} for {} unavailable, trying to reinitialize", (Object)id, (Object)PlayerWeaponData.getPlayerName(player));
        PlayerWeaponData.initPlayerWeaponData(player);
    }

    public static int getLastWarhammerSmashTicks(EntityPlayer player) {
        try {
            return (Integer)player.func_184212_Q().func_187225_a(WARHAMMER_LAST_SMASH_TICKS);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS.func_187155_a());
            return 0;
        }
    }

    public static void setLastWarhammerSmashTicks(EntityPlayer player, int age) {
        try {
            player.func_184212_Q().func_187227_b(WARHAMMER_LAST_SMASH_TICKS, (Object)age);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, WARHAMMER_LAST_SMASH_TICKS.func_187155_a());
        }
    }

    public static boolean isFlailThrown(EntityPlayer player) {
        try {
            return (Boolean)player.func_184212_Q().func_187225_a(FLAIL_THROWN);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN.func_187155_a());
            return false;
        }
    }

    public static void setFlailThrown(EntityPlayer player, boolean flag) {
        try {
            player.func_184212_Q().func_187227_b(FLAIL_THROWN, (Object)flag);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_THROWN.func_187155_a());
        }
    }

    public static int getFlailEntityId(EntityPlayer player) {
        try {
            return (Integer)player.func_184212_Q().func_187225_a(FLAIL_ENTITY_ID);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID.func_187155_a());
            return 0;
        }
    }

    public static void setFlailEntityId(EntityPlayer player, int id) {
        try {
            player.func_184212_Q().func_187227_b(FLAIL_ENTITY_ID, (Object)id);
        }
        catch (NullPointerException e) {
            PlayerWeaponData.unavailableError(player, FLAIL_ENTITY_ID.func_187155_a());
        }
    }
}

