/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.AdvancedExplosion;
import ckathode.weaponmod.network.WMMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MsgExplosion
extends WMMessage {
    private double x;
    private double y;
    private double z;
    private float size;
    private List<BlockPos> blocks;
    private boolean smallParticles;
    private boolean bigParticles;

    public MsgExplosion() {
    }

    public MsgExplosion(AdvancedExplosion explosion, boolean smallparts, boolean bigparts) {
        this.x = explosion.explosionX;
        this.y = explosion.explosionY;
        this.z = explosion.explosionZ;
        this.size = explosion.explosionSize;
        this.blocks = explosion.func_180343_e();
        this.smallParticles = smallparts;
        this.bigParticles = bigparts;
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.size = buf.readFloat();
        this.smallParticles = buf.readBoolean();
        this.bigParticles = buf.readBoolean();
        int size = buf.readInt();
        this.blocks = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            int ix = buf.readByte() + (int)this.x;
            int iy = buf.readByte() + (int)this.y;
            int iz = buf.readByte() + (int)this.z;
            this.blocks.add(new BlockPos(ix, iy, iz));
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeFloat(this.size);
        buf.writeBoolean(this.smallParticles);
        buf.writeBoolean(this.bigParticles);
        buf.writeInt(this.blocks.size());
        for (BlockPos pos : this.blocks) {
            int dx = pos.func_177958_n() - (int)this.x;
            int dy = pos.func_177956_o() - (int)this.y;
            int dz = pos.func_177952_p() - (int)this.z;
            buf.writeByte(dx);
            buf.writeByte(dy);
            buf.writeByte(dz);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        AdvancedExplosion expl = new AdvancedExplosion((World)world, null, this.x, this.y, this.z, this.size, false, true);
        expl.setAffectedBlockPositions(this.blocks);
        expl.doParticleExplosion(this.smallParticles, this.bigParticles);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

