/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.network;

import ckathode.weaponmod.BalkonsWeaponMod;
import ckathode.weaponmod.network.WMMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ChannelHandler.Sharable
public class WMMessagePipeline
extends MessageToMessageCodec<FMLProxyPacket, WMMessage> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private final LinkedList<Class<? extends WMMessage>> packets = new LinkedList();
    private boolean isPostInitialized = false;

    public boolean registerPacket(Class<? extends WMMessage> clazz) {
        if (this.packets.size() > 256) {
            BalkonsWeaponMod.modLog.error("More than 256 packets registered");
            return false;
        }
        if (this.packets.contains(clazz)) {
            BalkonsWeaponMod.modLog.warn("Packet already registered");
            return false;
        }
        if (this.isPostInitialized) {
            BalkonsWeaponMod.modLog.error("Already post-initialized");
            return false;
        }
        this.packets.add(clazz);
        return true;
    }

    protected void encode(ChannelHandlerContext ctx, WMMessage msg, List<Object> out) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        if (!this.packets.contains(msg.getClass())) {
            throw new NullPointerException("No Packet Registered for: " + msg.getClass().getCanonicalName());
        }
        byte discriminator = (byte)this.packets.indexOf(msg.getClass());
        buffer.writeByte((int)discriminator);
        msg.encodeInto(ctx, (ByteBuf)buffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer, (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        byte discriminator;
        Class<? extends WMMessage> clazz;
        ByteBuf payload = msg.payload().duplicate();
        if (payload.readableBytes() < 1) {
            FMLLog.log.error("The FMLIndexedCodec has received an empty buffer on channel %s, likely a result of a LAN server issue. Pipeline parts : %s", new Object[]{ctx.channel().attr(NetworkRegistry.FML_CHANNEL), ctx.pipeline().toString()});
        }
        if ((clazz = this.packets.get(discriminator = payload.readByte())) == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        WMMessage pkt = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        pkt.decodeInto(ctx, payload.slice());
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer player = this.getClientPlayer();
                pkt.handleClientSide(player);
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                pkt.handleServerSide((EntityPlayer)player);
                break;
            }
        }
        out.add(pkt);
    }

    public void initialize() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("WeaponMod", new ChannelHandler[]{this});
    }

    public void postInitialize() {
        if (this.isPostInitialized) {
            return;
        }
        this.isPostInitialized = true;
        this.packets.sort((clazz1, clazz2) -> {
            int com = String.CASE_INSENSITIVE_ORDER.compare(clazz1.getCanonicalName(), clazz2.getCanonicalName());
            if (com == 0) {
                com = clazz1.getCanonicalName().compareTo(clazz2.getCanonicalName());
            }
            return com;
        });
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(WMMessage message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendTo(WMMessage message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(WMMessage message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(WMMessage message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(WMMessage message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }
}

