/*
 * Decompiled with CFR 0.152.
 */
package xjon.developercapes.cape;

import com.google.common.collect.HashBiMap;
import com.google.common.primitives.UnsignedBytes;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.BitSet;
import java.util.Map;
import xjon.developercapes.DevCapes;
import xjon.developercapes.cape.CapeConfig;
import xjon.developercapes.user.Group;
import xjon.developercapes.user.GroupManager;
import xjon.developercapes.user.User;
import xjon.developercapes.user.UserManager;

public class CapeConfigManager {
    protected static CapeConfigManager instance;
    protected static BitSet availableIds;
    protected HashBiMap<Integer, CapeConfig> configs = HashBiMap.create();

    public static CapeConfigManager getInstance() {
        if (instance == null) {
            instance = new CapeConfigManager();
        }
        return instance;
    }

    public void addConfig(int id, CapeConfig config) throws InvalidCapeConfigIdException {
        int realId = CapeConfigManager.claimId(id);
        this.configs.put((Object)realId, (Object)config);
        this.addUsers(config.users);
        this.addGroups(config.groups);
    }

    protected void addUsers(Map<String, User> users) {
        try {
            UserManager.getInstance().addUsers(users.values());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addGroups(Map<String, Group> groups) {
        try {
            GroupManager.getInstance().addGroups(groups.values());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CapeConfig getConfig(int id) {
        return (CapeConfig)this.configs.get((Object)id);
    }

    public int getIdForConfig(CapeConfig config) {
        return (Integer)this.configs.inverse().get((Object)config);
    }

    public static int getUniqueId() {
        return availableIds.nextClearBit(1);
    }

    public static int claimId(int id) throws InvalidCapeConfigIdException {
        if (id <= 0) {
            throw new InvalidCapeConfigIdException("The config ID must be a positive non-zero integer");
        }
        try {
            UnsignedBytes.checkedCast((long)id);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        boolean isRegistered = availableIds.get(id);
        if (isRegistered) {
            throw new InvalidCapeConfigIdException(String.format("The config ID %d is already claimed.", id));
        }
        availableIds.set(id);
        return id;
    }

    public CapeConfig parse(InputStream is) {
        if (is == null) {
            throw new NullPointerException("Can not parse a null input stream!");
        }
        CapeConfig instance = new CapeConfig();
        InputStreamReader isr = new InputStreamReader(is);
        try {
            Map entries = (Map)new Gson().fromJson((Reader)isr, Map.class);
            for (Map.Entry entry : entries.entrySet()) {
                String nodeName = (String)entry.getKey();
                Object obj = entry.getValue();
                if (obj instanceof Map) {
                    this.parseGroup(instance, nodeName, (Map)obj);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                this.parseUser(instance, nodeName, (String)obj);
            }
        }
        catch (JsonSyntaxException e) {
            DevCapes.logger.error("CapeConfig could not be parsed because:");
            e.printStackTrace();
        }
        return instance;
    }

    protected void parseGroup(CapeConfig config, String node, Map group) {
        Group g = GroupManager.getInstance().parse(node, group);
        if (g != null) {
            config.groups.put(g.name, g);
        }
    }

    protected void parseUser(CapeConfig config, String node, String user) {
        User u = UserManager.getInstance().parse(node, user);
        if (u != null) {
            config.users.put(node, u);
        }
    }

    @Deprecated
    public CapeConfig parseFromStream(InputStream is) {
        return this.parse(is);
    }

    static {
        availableIds = new BitSet(256);
        availableIds.clear(availableIds.size());
    }

    public static class InvalidCapeConfigIdException
    extends Exception {
        public InvalidCapeConfigIdException() {
        }

        public InvalidCapeConfigIdException(String s) {
            super(s);
        }

        public InvalidCapeConfigIdException(Throwable cause) {
            super(cause);
        }

        public InvalidCapeConfigIdException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

