/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.entity.EntityMobRandomizer;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PhilosophersStone
extends ItemMode
implements IProjectileShooter,
IExtraFunction {
    public PhilosophersStone() {
        super("philosophers_stone", 4, new String[]{"pe.philstone.mode1", "pe.philstone.mode2", "pe.philstone.mode3"});
        this.func_77642_a(this);
        this.setNoRepair();
    }

    public RayTraceResult getHitBlock(EntityPlayer player) {
        return this.func_77621_a(player.func_130014_f_(), player, player.func_70093_af());
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing sideHit, float px, float py, float pz) {
        IBlockState result;
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        RayTraceResult rtr = this.getHitBlock(player);
        if (rtr != null && rtr.func_178782_a() != null && !rtr.func_178782_a().equals((Object)pos)) {
            pos = rtr.func_178782_a();
            sideHit = rtr.field_178784_b;
        }
        if ((result = WorldTransmutations.getWorldTransmutation(world, pos, player.func_70093_af())) != null) {
            byte mode = this.getMode(player.func_184586_b(hand));
            int charge = this.getCharge(player.func_184586_b(hand));
            for (BlockPos currentPos : PhilosophersStone.getAffectedPositions(world, pos, player, sideHit, mode, charge)) {
                PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, currentPos, result, hand);
                if (world.field_73012_v.nextInt(8) != 0) continue;
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)currentPos.func_177958_n(), (double)(currentPos.func_177956_o() + 1), (double)currentPos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.0, new int[0]);
            }
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.TRANSMUTE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            PlayerHelper.swingItem(player, hand);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean shootProjectile(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        World world = player.func_130014_f_();
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.TRANSMUTE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityMobRandomizer ent = new EntityMobRandomizer(world, player);
        ent.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_72838_d((Entity)ent);
        return true;
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, EnumHand hand) {
        if (!player.func_130014_f_().field_72995_K) {
            player.openGui((Object)PECore.instance, 13, player.func_130014_f_(), hand == EnumHand.MAIN_HAND ? 0 : 1, -1, -1);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        super.func_77624_a(stack, world, list, flags);
        list.add(I18n.func_135052_a((String)"pe.philstone.tooltip1", (Object[])new Object[]{ClientKeyHelper.getKeyName(PEKeybind.EXTRA_FUNCTION)}));
    }

    public static Set<BlockPos> getAffectedPositions(World world, BlockPos pos, EntityPlayer player, EnumFacing sideHit, int mode, int charge) {
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        IBlockState targeted = world.func_180495_p(pos);
        Iterable iterable = null;
        switch (mode) {
            case 0: {
                iterable = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-charge, -charge, -charge), (BlockPos)pos.func_177982_a(charge, charge, charge));
                break;
            }
            case 1: {
                if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                    iterable = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-charge, 0, -charge), (BlockPos)pos.func_177982_a(charge, 0, charge));
                    break;
                }
                if (sideHit == EnumFacing.EAST || sideHit == EnumFacing.WEST) {
                    iterable = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(0, -charge, -charge), (BlockPos)pos.func_177982_a(0, charge, charge));
                    break;
                }
                if (sideHit != EnumFacing.SOUTH && sideHit != EnumFacing.NORTH) break;
                iterable = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-charge, -charge, 0), (BlockPos)pos.func_177982_a(charge, charge, 0));
                break;
            }
            case 2: {
                EnumFacing playerFacing = player.func_174811_aO();
                if (playerFacing.func_176740_k() == EnumFacing.Axis.Z) {
                    iterable = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(0, 0, -charge), (BlockPos)pos.func_177982_a(0, 0, charge));
                    break;
                }
                if (playerFacing.func_176740_k() != EnumFacing.Axis.X) break;
                iterable = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-charge, 0, 0), (BlockPos)pos.func_177982_a(charge, 0, 0));
            }
        }
        if (iterable != null) {
            for (BlockPos currentPos : iterable) {
                if (world.func_180495_p(currentPos) != targeted) continue;
                ret.add(currentPos);
            }
        }
        return ret;
    }
}

