/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.collision;

import com.pau101.fairylights.server.fastener.connection.Feature;
import com.pau101.fairylights.server.fastener.connection.FeatureType;
import com.pau101.fairylights.server.fastener.connection.collision.Collidable;
import com.pau101.fairylights.server.fastener.connection.collision.Intersection;
import com.pau101.fairylights.util.Mth;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public final class FeatureCollisionTree
implements Collidable {
    private final FeatureType type;
    private final AxisAlignedBB[] tree;
    private final Feature[] nodeToFeature;

    private FeatureCollisionTree(FeatureType type, AxisAlignedBB[] tree, Feature[] nodeToFeature) {
        this.type = type;
        this.tree = tree;
        this.nodeToFeature = nodeToFeature;
    }

    @Override
    @Nullable
    public Intersection intersect(Vec3d origin, Vec3d end) {
        return this.intersect(origin, end, 0);
    }

    @Nullable
    private Intersection intersect(Vec3d origin, Vec3d end, int node) {
        RayTraceResult result = this.tree[node].func_72318_a(origin) ? new RayTraceResult(origin, EnumFacing.UP) : this.tree[node].func_72327_a(origin, end);
        if (result == null) {
            return null;
        }
        int nL = node * 2 + 1;
        if (nL >= this.tree.length || this.tree[nL] == null) {
            return new Intersection(result, this.tree[node], this.type, this.nodeToFeature[node]);
        }
        Intersection intersection = this.intersect(origin, end, nL);
        if (intersection != null) {
            return intersection;
        }
        return this.intersect(origin, end, node * 2 + 2);
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, T[] features, Function<T, AxisAlignedBB> mapper) {
        return FeatureCollisionTree.build((FeatureType)type, features, mapper, (int)0, (int)(features.length - 1));
    }

    public static <T extends Feature> FeatureCollisionTree build(FeatureType type, T[] features, Function<T, AxisAlignedBB> mapper, int start, int end) {
        AxisAlignedBB[] tree = new AxisAlignedBB[end == 0 ? 1 : (1 << Mth.log2(end - start) + 2) - 1];
        Feature[] treeFeatures = new Feature[tree.length];
        tree[0] = FeatureCollisionTree.build(features, mapper, (AxisAlignedBB[])tree, (Feature[])treeFeatures, (int)start, (int)end, (int)0);
        return new FeatureCollisionTree(type, tree, treeFeatures);
    }

    private static <T extends Feature> AxisAlignedBB build(T[] features, Function<T, AxisAlignedBB> mapper, AxisAlignedBB[] tree, Feature[] treeFeatures, int min, int max, int node) {
        if (min > max) {
            throw new IllegalStateException(String.format("min > max, len: %d, tree: %s, min: %d, max: %d, node: %d", features.length, Arrays.toString(tree), min, max, node));
        }
        if (min == max) {
            T obj = features[min];
            treeFeatures[node] = obj;
            return mapper.apply(obj);
        }
        int mid = min + (max - min) / 2;
        int nL = node * 2 + 1;
        int nR = node * 2 + 2;
        tree[nL] = FeatureCollisionTree.build(features, mapper, (AxisAlignedBB[])tree, (Feature[])treeFeatures, (int)min, (int)mid, (int)nL);
        tree[nR] = FeatureCollisionTree.build(features, mapper, (AxisAlignedBB[])tree, (Feature[])treeFeatures, (int)(mid + 1), (int)max, (int)nR);
        return tree[nL].func_111270_a(tree[nR]);
    }
}

