/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type.hanginglights;

import com.pau101.fairylights.server.config.Configurator;
import com.pau101.fairylights.server.fastener.connection.type.ConnectionHangingFeature;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.ConnectionHangingLights;
import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.server.sound.FLSounds;
import com.pau101.fairylights.util.CubicBezier;
import com.pau101.fairylights.util.Mth;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class Light
extends ConnectionHangingFeature.HangingFeature<Light> {
    private static final CubicBezier EASE_IN_OUT = new CubicBezier(0.4f, 0.0f, 0.6f, 1.0f);
    private static final int NORMAL_LIGHT = -1;
    private static final int SWAY_RATE = 10;
    private static final int SWAY_PEAK_COUNT = 5;
    private static final int SWAY_CYCLE = 50;
    private LightVariant variant = LightVariant.FAIRY;
    private Vec3d color = new Vec3d(1.0, 0.92, 0.76);
    private int prevTwinkleTime;
    private int twinkleTime = -1;
    private boolean isTwinkling;
    private int sway;
    private boolean swaying;
    private boolean swayDirection;
    private int tick;
    private int lastJingledTick = -1;

    public Light(int index, Vec3d point, Vec3d rotation, boolean isOn) {
        super(index, point, rotation);
        this.isTwinkling = !isOn;
    }

    public boolean isTwinkling() {
        return this.isTwinkling;
    }

    public float getBrightness(float delta) {
        return this.twinkleTime == -1 ? (this.isTwinkling ? 0.0f : 1.0f) : this.brightnessFunc(((float)this.prevTwinkleTime + (float)(this.twinkleTime - this.prevTwinkleTime) * delta) / (float)this.getVariant().getTickCycle());
    }

    public float getTwinkleTimePercent(float delta) {
        return this.twinkleTime == -1 ? 0.0f : ((float)this.prevTwinkleTime + (float)(this.twinkleTime - this.prevTwinkleTime) * delta) / (float)this.getVariant().getTickCycle();
    }

    private float brightnessFunc(float x) {
        return x < 0.25f ? EASE_IN_OUT.eval(x / 0.25f) : 1.0f - EASE_IN_OUT.eval(Mth.transform(x, 0.25f, 1.0f, 0.0f, 1.0f));
    }

    public LightVariant getVariant() {
        return this.variant;
    }

    public Vec3d getLight() {
        return this.color;
    }

    public void setVariant(LightVariant variant) {
        this.variant = variant;
    }

    public void setColor(int colorValue) {
        this.color = new Vec3d((double)((float)(colorValue >> 16 & 0xFF) / 255.0f), (double)((float)(colorValue >> 8 & 0xFF) / 255.0f), (double)((float)(colorValue & 0xFF) / 255.0f));
    }

    public void setRotation(Vec3d rotation) {
        this.rotation = rotation;
    }

    public void setTwinkleTime(int twinkleTime) {
        this.twinkleTime = twinkleTime;
    }

    public int getTwinkleTime() {
        return this.twinkleTime;
    }

    @Override
    public void inherit(Light parent) {
        super.inherit(parent);
        this.twinkleTime = parent.twinkleTime;
        this.swayDirection = parent.swayDirection;
        this.swaying = parent.swaying;
        this.sway = parent.sway;
        this.tick = parent.tick;
        this.lastJingledTick = parent.lastJingledTick;
    }

    public void jingle(World world, Vec3d origin, int note) {
        this.jingle(world, origin, note, EnumParticleTypes.NOTE);
    }

    public void jingle(World world, Vec3d origin, int note, EnumParticleTypes particle) {
        this.jingle(world, origin, note, FLSounds.JINGLE_BELL, particle);
    }

    public void jingle(World world, Vec3d origin, int note, SoundEvent sound, EnumParticleTypes ... particles) {
        if (world.field_72995_K) {
            double x = origin.field_72450_a + this.point.field_72450_a / 16.0;
            double y = origin.field_72448_b + this.point.field_72448_b / 16.0;
            double z = origin.field_72449_c + this.point.field_72449_c / 16.0;
            for (EnumParticleTypes particle : particles) {
                double vx = world.field_73012_v.nextGaussian();
                double vy = world.field_73012_v.nextGaussian();
                double vz = world.field_73012_v.nextGaussian();
                double t = world.field_73012_v.nextDouble() * 0.2 + 0.2;
                double mag = t / Math.sqrt(vx * vx + vy * vy + vz * vz);
                world.func_175688_a(particle, x + (vx *= mag), y + (vy *= mag), z + (vz *= mag), particle == EnumParticleTypes.NOTE ? (double)note / 24.0 : 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.lastJingledTick != this.tick) {
                world.func_184134_a(x, y, z, sound, SoundCategory.BLOCKS, (float)Configurator.getJingleAmplitude() / 16.0f, (float)Math.pow(2.0, (float)(note - 12) / 12.0f), false);
                this.startSwaying(world.field_73012_v.nextBoolean());
                this.lastJingledTick = this.tick;
            }
        }
    }

    public void startSwaying(boolean swayDirection) {
        this.swayDirection = swayDirection;
        this.swaying = true;
        this.sway = 0;
    }

    public void stopSwaying() {
        this.sway = 0;
        this.rotation = new Vec3d(this.rotation.field_72450_a, this.rotation.field_72448_b, 0.0);
        this.swaying = false;
    }

    public void tick(ConnectionHangingLights lights, boolean twinkle, boolean isOn) {
        this.prevRotation = this.rotation;
        this.prevTwinkleTime = this.twinkleTime;
        if (isOn) {
            if (this.isTwinkling || this.variant.alwaysDoTwinkleLogic()) {
                if (lights.getWorld().field_73012_v.nextFloat() < this.getVariant().getTwinkleChance() && this.twinkleTime == -1) {
                    this.twinkleTime = 0;
                }
                if (this.twinkleTime >= 0) {
                    ++this.twinkleTime;
                }
                if (this.twinkleTime == this.variant.getTickCycle()) {
                    this.twinkleTime = -1;
                }
            } else {
                this.twinkleTime = -1;
            }
            this.isTwinkling = twinkle;
        } else {
            this.twinkleTime = -1;
            this.isTwinkling = true;
        }
        if (this.swaying) {
            if (this.sway >= 50) {
                this.stopSwaying();
            } else {
                this.rotation = new Vec3d(this.rotation.field_72450_a, this.rotation.field_72448_b, (double)((float)(Math.sin((double)((this.swayDirection ? 1 : -1) * 2) * Math.PI / 10.0 * (double)this.sway) * Math.pow(114.59155902616465, (float)(-this.sway) / 50.0f))));
                ++this.sway;
            }
        }
        ++this.tick;
    }

    @Override
    public double getWidth() {
        return this.variant.getWidth();
    }

    @Override
    public double getHeight() {
        return this.variant.getHeight();
    }

    @Override
    public boolean parallelsCord() {
        return this.variant.parallelsCord();
    }
}

