/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.jingle;

import com.google.common.collect.Sets;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.Light;
import com.pau101.fairylights.server.jingle.Jingle;
import com.pau101.fairylights.server.jingle.JingleLibrary;
import com.pau101.fairylights.server.sound.FLSounds;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class JinglePlayer {
    private static final Set<String> WITH_LOVE = Sets.newHashSet((Object[])new String[]{"my_anthem", "im_fine_thank_you"});
    private State<?> state = new NotPlayingState();

    @Nullable
    public Jingle getJingle() {
        return this.state.getJingle();
    }

    public boolean isPlaying() {
        return this.state.isPlaying();
    }

    public float getProgress() {
        return this.state.getProgress();
    }

    public void play(JingleLibrary library, Jingle jingle, int lightOffset) {
        this.state = new PlayingState(library, jingle, lightOffset);
    }

    public void tick(World world, Vec3d origin, Light[] lights, boolean isClient) {
        this.state = this.state.tick(world, origin, lights, isClient);
    }

    public NBTTagCompound serialize() {
        return StateType.serialize(this.state);
    }

    public void deserialize(NBTTagCompound compound) {
        this.state = StateType.deserialize(compound);
    }

    private static final class PlayingState
    extends State<PlayingState> {
        public static final StateFactory<PlayingState> FACTORY = PlayingState.newFactory();
        private final JingleLibrary library;
        private final Jingle jingle;
        private final int lightOffset;
        private final List<Jingle.PlayTick> playTicks;
        private final int length;
        private final EnumParticleTypes[] noteParticle;
        private int index;
        private int rest;
        private int time;

        private PlayingState(JingleLibrary library, Jingle jingle, int lightOffset) {
            this(library, jingle, lightOffset, jingle.getPlayTicks(), jingle.getLength(), PlayingState.getParticles(jingle));
        }

        private PlayingState(JingleLibrary library, Jingle jingle, int lightOffset, List<Jingle.PlayTick> playTicks, int length, EnumParticleTypes[] noteParticle) {
            this.library = library;
            this.jingle = jingle;
            this.lightOffset = lightOffset;
            this.playTicks = playTicks;
            this.length = length;
            this.noteParticle = noteParticle;
        }

        @Override
        public Jingle getJingle() {
            return this.jingle;
        }

        @Override
        public boolean isPlaying() {
            return true;
        }

        @Override
        public float getProgress() {
            return (float)this.time / (float)this.length;
        }

        @Override
        public State<?> tick(World world, Vec3d origin, Light[] lights, boolean isClient) {
            ++this.time;
            if (this.rest <= 0) {
                if (this.index >= this.playTicks.size()) {
                    return new NotPlayingState();
                }
                Jingle.PlayTick playTick = this.playTicks.get(this.index++);
                this.rest = playTick.getLength() - 1;
                if (isClient) {
                    this.play(world, origin, lights, playTick);
                }
            } else {
                --this.rest;
            }
            return this;
        }

        private void play(World world, Vec3d origin, Light[] lights, Jingle.PlayTick playTick) {
            for (int note : playTick.getNotes()) {
                int idx = note - this.jingle.getLowestNote() + this.lightOffset;
                if (idx < 0 || idx >= lights.length) continue;
                lights[idx].jingle(world, origin, note, FLSounds.JINGLE_BELL, this.noteParticle);
            }
        }

        @Override
        public StateFactory<PlayingState> getFactory() {
            return FACTORY;
        }

        @Override
        public PlayingState resolve() {
            return this;
        }

        private static StateFactory<PlayingState> newFactory() {
            return new StateFactory<PlayingState>(){

                @Override
                public String getId() {
                    return "playing";
                }

                @Override
                public NBTTagCompound serialize(PlayingState state) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74768_a("library", state.library.getId());
                    compound.func_74778_a("jingle", state.jingle.getId());
                    compound.func_74768_a("lightOffset", state.lightOffset);
                    compound.func_74768_a("index", state.index);
                    compound.func_74768_a("rest", state.rest);
                    compound.func_74768_a("time", state.time);
                    return compound;
                }

                @Override
                public State<?> deserialize(NBTTagCompound compound) {
                    JingleLibrary library = JingleLibrary.fromId(compound.func_74762_e("library"));
                    Jingle jingle = library.get(compound.func_74779_i("jingle"));
                    if (jingle == null) {
                        return new NotPlayingState();
                    }
                    int lightOffset = compound.func_74762_e("lightOffset");
                    PlayingState state = new PlayingState(library, jingle, lightOffset);
                    state.index = compound.func_74762_e("index");
                    state.rest = compound.func_74762_e("rest");
                    state.time = compound.func_74762_e("time");
                    return state;
                }
            };
        }

        private static EnumParticleTypes[] getParticles(Jingle jingle) {
            if ("playing_with_fire".equals(jingle.getId())) {
                return new EnumParticleTypes[]{EnumParticleTypes.NOTE, EnumParticleTypes.LAVA};
            }
            if (WITH_LOVE.contains(jingle.getId())) {
                return new EnumParticleTypes[]{EnumParticleTypes.NOTE, EnumParticleTypes.HEART};
            }
            return new EnumParticleTypes[]{EnumParticleTypes.NOTE};
        }
    }

    private static final class NotPlayingState
    extends State<NotPlayingState> {
        public static final StateFactory<NotPlayingState> FACTORY = NotPlayingState.newFactory();

        private NotPlayingState() {
        }

        @Override
        public Jingle getJingle() {
            return null;
        }

        @Override
        public boolean isPlaying() {
            return false;
        }

        @Override
        public float getProgress() {
            return 0.0f;
        }

        @Override
        public State<?> tick(World world, Vec3d origin, Light[] lights, boolean isClient) {
            return this;
        }

        @Override
        public StateFactory<NotPlayingState> getFactory() {
            return FACTORY;
        }

        @Override
        public NotPlayingState resolve() {
            return this;
        }

        private static StateFactory<NotPlayingState> newFactory() {
            return new StateFactory<NotPlayingState>(){

                @Override
                public String getId() {
                    return "not_playing";
                }

                @Override
                public NBTTagCompound serialize(NotPlayingState state) {
                    return new NBTTagCompound();
                }

                public NotPlayingState deserialize(NBTTagCompound compound) {
                    return new NotPlayingState();
                }
            };
        }
    }

    private static abstract class State<S extends State<S>> {
        private State() {
        }

        public abstract Jingle getJingle();

        public abstract boolean isPlaying();

        public abstract float getProgress();

        public abstract State<?> tick(World var1, Vec3d var2, Light[] var3, boolean var4);

        public abstract StateFactory<S> getFactory();

        public abstract S resolve();
    }

    private static abstract class StateFactory<S extends State<S>> {
        private StateFactory() {
        }

        public abstract String getId();

        public abstract NBTTagCompound serialize(S var1);

        public abstract State<?> deserialize(NBTTagCompound var1);
    }

    private static enum StateType {
        NOT_PLAYING(NotPlayingState.FACTORY),
        PLAYING(PlayingState.FACTORY);

        private static final Map<String, StateType> MAP;
        private final StateFactory<?> factory;

        private StateType(StateFactory<?> factory) {
            this.factory = factory;
        }

        private String getId() {
            return this.factory.getId();
        }

        private StateFactory<?> getFactory() {
            return this.factory;
        }

        public static <S extends State<S>> NBTTagCompound serialize(State<S> state) {
            StateFactory<S> factory = state.getFactory();
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("state", factory.getId());
            compound.func_74782_a("data", (NBTBase)factory.serialize(state.resolve()));
            return compound;
        }

        public static State<?> deserialize(NBTTagCompound compound) {
            return MAP.getOrDefault(compound.func_74779_i("state"), NOT_PLAYING).getFactory().deserialize(compound.func_74775_l("data"));
        }

        static {
            MAP = Stream.of(StateType.values()).collect(Collectors.toMap(StateType::getId, Function.identity()));
        }
    }
}

