/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.network.impl;

import com.google.common.collect.Lists;
import elec332.core.ElecCore;
import elec332.core.api.network.ElecByteBuf;
import elec332.core.api.network.INetworkHandler;
import elec332.core.api.network.IPacketDispatcher;
import elec332.core.api.network.object.INetworkObject;
import elec332.core.api.network.object.INetworkObjectHandler;
import elec332.core.api.network.object.INetworkObjectManager;
import elec332.core.api.network.object.INetworkObjectReceiver;
import elec332.core.api.network.object.INetworkObjectSender;
import elec332.core.api.util.IEntityFilter;
import elec332.core.network.impl.DefaultByteBufFactory;
import elec332.core.network.impl.ElecByteBufImpl;
import elec332.core.util.FMLUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

class DefaultNetworkObjectManager
implements INetworkObjectManager,
IMessageHandler<PacketNetworkObject, IMessage> {
    private IPacketDispatcher packetDispatcher;
    private final List<NOH> packetStuff;
    private byte i;

    DefaultNetworkObjectManager(INetworkHandler handler) {
        this.packetDispatcher = handler;
        handler.registerPacket(this, PacketNetworkObject.class, Side.CLIENT);
        handler.registerPacket(this, PacketNetworkObject.class, Side.SERVER);
        this.packetStuff = Lists.newArrayList();
        this.i = 0;
    }

    @Override
    public <N extends INetworkObjectReceiver> INetworkObjectHandler<?> registerNetworkObject(N networkObject) {
        if (networkObject instanceof INetworkObjectSender) {
            return this.registerNetworkObject(networkObject, (S)((INetworkObjectSender)((Object)networkObject)));
        }
        if (!FMLUtil.isInModInitialisation()) {
            throw new IllegalStateException();
        }
        NOH ret = new NOH(this, this.i, null, networkObject);
        this.packetStuff.add(ret);
        this.i = (byte)(this.i + 1);
        networkObject.setNetworkObjectHandler(ret);
        return ret;
    }

    public <N extends INetworkObjectReceiver, S extends INetworkObjectSender> INetworkObjectHandler<S> registerNetworkObject(@Nullable N networkObjectR, @Nullable S networkObjectS) {
        if (!FMLUtil.isInModInitialisation() || networkObjectS == null && networkObjectR == null) {
            throw new IllegalStateException();
        }
        NOH ret = new NOH(this, this.i, networkObjectS, networkObjectR);
        this.packetStuff.add(ret);
        this.i = (byte)(this.i + 1);
        if (networkObjectS != networkObjectR) {
            if (networkObjectR != null) {
                networkObjectR.setNetworkObjectHandler(ret);
            }
            if (networkObjectS != null) {
                networkObjectS.setNetworkObjectHandler(ret);
            }
        } else {
            networkObjectR.setNetworkObjectHandler(ret);
        }
        return ret;
    }

    @Override
    public <N extends INetworkObject> INetworkObjectHandler<N> registerSpecialNetworkObject(N networkObject) {
        if (!FMLUtil.isInModInitialisation()) {
            throw new IllegalStateException();
        }
        NOH ret = new NOH(this, this.i, networkObject, networkObject);
        this.packetStuff.add(ret);
        this.i = (byte)(this.i + 1);
        networkObject.setNetworkObjectHandler(ret);
        return ret;
    }

    public IMessage onMessage(final PacketNetworkObject message, MessageContext ctx) {
        ElecCore.tickHandler.registerCall(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = DefaultNetworkObjectManager.this.packetStuff.iterator();
                NOH noh = (NOH)iterator.next();
                while (!noh.handle(message)) {
                    noh = (NOH)iterator.next();
                }
            }
        }, ctx.side);
        return null;
    }

    public static class PacketNetworkObject
    implements IMessage {
        byte i;
        byte i2;
        ByteBuf data;

        public PacketNetworkObject() {
        }

        PacketNetworkObject(byte b, byte b2, ByteBuf buf) {
            this.i = b;
            this.i2 = b2;
            this.data = buf;
        }

        public void fromBytes(ByteBuf buf) {
            this.i = buf.readByte();
            this.i2 = buf.readByte();
            this.data = buf.readBytes(Unpooled.buffer((int)buf.readableBytes()));
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte((int)this.i);
            buf.writeByte((int)this.i2);
            buf.writeBytes(this.data);
        }
    }

    private static class NOH<T extends INetworkObjectSender>
    implements INetworkObjectHandler<T>,
    DefaultByteBufFactory {
        private byte b;
        private T obj;
        private INetworkObjectReceiver receiver;
        final /* synthetic */ DefaultNetworkObjectManager this$0;

        private NOH(@Nullable byte i, @Nullable T obj, INetworkObjectReceiver receiver) {
            this.this$0 = var1_1;
            this.b = i;
            this.obj = obj;
            this.receiver = receiver;
        }

        @Override
        public void sendToAll(int id) {
            ByteBuf buf = Unpooled.buffer();
            if (this.getNetworkObjectSender() != null) {
                this.getNetworkObjectSender().writePacket(id, new ElecByteBufImpl(buf));
            }
            this.sendToAll(id, buf);
        }

        @Override
        public void sendTo(int id, IEntityFilter<EntityPlayerMP> playerFilter, MinecraftServer server) {
            ByteBuf buf = Unpooled.buffer();
            if (this.getNetworkObjectSender() != null) {
                this.getNetworkObjectSender().writePacket(id, new ElecByteBufImpl(buf));
            }
            this.sendTo(id, buf, playerFilter, server);
        }

        @Override
        public void sendTo(int id, List<EntityPlayerMP> players) {
            ByteBuf buf = Unpooled.buffer();
            if (this.getNetworkObjectSender() != null) {
                this.getNetworkObjectSender().writePacket(id, new ElecByteBufImpl(buf));
            }
            this.sendTo(id, buf, players);
        }

        @Override
        public void sendTo(int id, EntityPlayerMP player) {
            ByteBuf buf = Unpooled.buffer();
            if (this.getNetworkObjectSender() != null) {
                this.getNetworkObjectSender().writePacket(id, new ElecByteBufImpl(buf));
            }
            this.sendTo(id, buf, player);
        }

        @Override
        public void sendToAllAround(int id, NetworkRegistry.TargetPoint point) {
            ByteBuf buf = Unpooled.buffer();
            if (this.getNetworkObjectSender() != null) {
                this.getNetworkObjectSender().writePacket(id, new ElecByteBufImpl(buf));
            }
            this.sendToAllAround(id, buf, point);
        }

        @Override
        public void sendToDimension(int id, int dimensionId) {
            ByteBuf buf = Unpooled.buffer();
            if (this.getNetworkObjectSender() != null) {
                this.getNetworkObjectSender().writePacket(id, new ElecByteBufImpl(buf));
            }
            this.sendToDimension(id, buf, dimensionId);
        }

        @Override
        public void sendToServer(int id) {
            ByteBuf buf = Unpooled.buffer();
            if (this.getNetworkObjectSender() != null) {
                this.getNetworkObjectSender().writePacket(id, new ElecByteBufImpl(buf));
            }
            this.sendToServer(id, buf);
        }

        @Override
        public void sendToAll(int id, NBTTagCompound data) {
            this.sendToAll(id, this.fromTag(data));
        }

        @Override
        public void sendTo(int id, NBTTagCompound data, IEntityFilter<EntityPlayerMP> playerFilter, MinecraftServer server) {
            this.sendTo(id, this.fromTag(data), playerFilter, server);
        }

        @Override
        public void sendTo(int id, NBTTagCompound data, List<EntityPlayerMP> players) {
            this.sendTo(id, this.fromTag(data), players);
        }

        @Override
        public void sendTo(int id, NBTTagCompound data, EntityPlayerMP player) {
            this.sendTo(id, this.fromTag(data), player);
        }

        @Override
        public void sendToAllAround(int id, NBTTagCompound data, NetworkRegistry.TargetPoint point) {
            this.sendToAllAround(id, this.fromTag(data), point);
        }

        @Override
        public void sendToDimension(int id, NBTTagCompound data, int dimensionId) {
            this.sendToDimension(id, this.fromTag(data), dimensionId);
        }

        @Override
        public void sendToServer(int id, NBTTagCompound data) {
            this.sendToServer(id, this.fromTag(data));
        }

        @Override
        public void sendToAll(int id, ByteBuf data) {
            this.this$0.packetDispatcher.sendToAll(new PacketNetworkObject(this.b, (byte)id, data));
        }

        @Override
        public void sendTo(int id, ByteBuf data, EntityPlayerMP player) {
            this.this$0.packetDispatcher.sendTo((IMessage)new PacketNetworkObject(this.b, (byte)id, data), player);
        }

        @Override
        public void sendToAllAround(int id, ByteBuf data, NetworkRegistry.TargetPoint point) {
            this.this$0.packetDispatcher.sendToAllAround(new PacketNetworkObject(this.b, (byte)id, data), point);
        }

        @Override
        public void sendToDimension(int id, ByteBuf data, int dimensionId) {
            this.this$0.packetDispatcher.sendToDimension(new PacketNetworkObject(this.b, (byte)id, data), dimensionId);
        }

        @Override
        public void sendToServer(int id, ByteBuf data) {
            this.this$0.packetDispatcher.sendToServer(new PacketNetworkObject(this.b, (byte)id, data));
        }

        @Override
        @Nullable
        public T getNetworkObjectSender() {
            return this.obj;
        }

        private ByteBuf fromTag(NBTTagCompound tag) {
            ElecByteBufImpl buf = new ElecByteBufImpl(Unpooled.buffer());
            ((ElecByteBuf)buf).writeNBTTagCompoundToBuffer(tag);
            return buf;
        }

        private boolean handle(PacketNetworkObject packet) {
            if (packet.i == this.b) {
                try {
                    this.receiver.onPacket(packet.i2, new ElecByteBufImpl(packet.data));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
            return false;
        }
    }
}

