/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common;

import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.NetworkModHolder;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTweakerNetworkChecker
extends NetworkModHolder.NetworkChecker {
    private static final Logger LOGGER = LogManager.getLogger((String)"LootTweaker");

    private LootTweakerNetworkChecker(NetworkModHolder parent) {
        super(parent);
    }

    public boolean check(Map<String, String> modVersions, Side remoteSide) {
        return this.checkCompatible(modVersions, remoteSide) == null;
    }

    public String checkCompatible(Map<String, String> modVersions, Side remoteSide) {
        if (!modVersions.containsKey("forge")) {
            return "Rejected vanilla install";
        }
        String remoteLTVersion = modVersions.get("loottweaker");
        if (remoteLTVersion == null) {
            if (remoteSide == Side.CLIENT) {
                LOGGER.info("Accepted non-existent client LootTweaker install");
                return null;
            }
            return "Rejected non-existent server LootTweaker install";
        }
        if (!remoteLTVersion.equals("0.4.1")) {
            return String.format("Rejected %s LootTweaker install because its version %s differs from local version %s", remoteSide.name().toLowerCase(), remoteLTVersion, "0.4.1");
        }
        return null;
    }

    public static void install() {
        ModContainer lootTweaker = (ModContainer)Loader.instance().getIndexedModList().get("loottweaker");
        try {
            NetworkModHolder holder = LootTweakerNetworkChecker.getHolderRegistry().get(lootTweaker);
            Field checkerField = NetworkModHolder.class.getDeclaredField("checker");
            checkerField.setAccessible(true);
            checkerField.set(holder, (Object)new LootTweakerNetworkChecker(holder));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Failed to set network checker", e);
        }
        LOGGER.info("Successfully installed network checker");
    }

    private static Map<ModContainer, NetworkModHolder> getHolderRegistry() {
        try {
            Field registryField = NetworkRegistry.class.getDeclaredField("registry");
            registryField.setAccessible(true);
            return (Map)registryField.get(NetworkRegistry.INSTANCE);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Failed to get holder registry from network registry", e);
        }
    }
}

