/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import leviathan143.loottweaker.common.LootTweaker;
import leviathan143.loottweaker.common.command.Subcommand;
import leviathan143.loottweaker.common.lib.LootTableFinder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;

public class SubcommandGenerate
implements Subcommand {
    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            throw Subcommand.wrongUsage(".commands.generate.type.missing", new Object[0]);
        }
        String type = args[1];
        if (!type.equals("chest") && !type.equals("entity")) {
            throw Subcommand.wrongUsage(".commands.generate.type.unknown", type);
        }
        ResourceLocation tableId = new ResourceLocation(args[2]);
        if (!LootTableFinder.DEFAULT.exists(tableId)) {
            throw Subcommand.wrongUsage(".messages.error.invalidTableName", tableId);
        }
        RayTraceResult target = sender.func_174793_f().func_174822_a(8.0, 1.0f);
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            World world = sender.func_130014_f_();
            BlockPos pos = this.choosePosition(world, target);
            switch (type) {
                case "chest": {
                    TileEntityChest chest = this.placeChest(world, sender.func_174793_f(), pos);
                    chest.func_174888_l();
                    chest.func_189404_a(tableId, 0L);
                    break;
                }
                case "entity": {
                    this.generateEntity(sender, args, world, pos, tableId);
                }
            }
        }
    }

    private void generateEntity(ICommandSender sender, String[] args, World world, BlockPos pos, ResourceLocation tableId) throws CommandException {
        String id;
        NBTTagCompound nbt;
        if (args.length < 4) {
            throw Subcommand.wrongUsage(".commands.generate.missingEntityId", new Object[0]);
        }
        boolean hasNbt = false;
        if (args.length == 5) {
            hasNbt = true;
            String nbtString = CommandBase.func_180529_a((String[])args, (int)4);
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtString);
                hasNbt = true;
            }
            catch (NBTException nbtexception) {
                sender.func_145747_a((ITextComponent)LootTweaker.translation(".commands.generate.nbtError", new Object[0]));
                nbtexception.printStackTrace();
                return;
            }
        } else {
            nbt = new NBTTagCompound();
        }
        if (!EntityList.func_180125_b((ResourceLocation)new ResourceLocation(id = args[3]))) {
            throw Subcommand.wrongUsage(".commands.generate.invalidEntityId", id);
        }
        nbt.func_74778_a("LootTable", tableId.toString());
        nbt.func_74778_a("DeathLootTable", tableId.toString());
        this.summonEntity(world, id, pos, nbt, hasNbt);
    }

    private Entity summonEntity(World world, String id, BlockPos pos, NBTTagCompound nbt, boolean hasNbt) {
        nbt.func_74778_a("id", id);
        Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbt, (World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (boolean)true);
        entity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), entity.field_70177_z, entity.field_70125_A);
        if (!hasNbt && entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_180482_a(world.func_175649_E(pos), null);
        }
        return entity;
    }

    private TileEntityChest placeChest(World world, Entity placer, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150486_ae) {
            world.func_175655_b(pos, false);
            world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)placer.func_174811_aO().func_176734_d()));
        } else {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        }
        TileEntity te = world.func_175625_s(pos);
        return (TileEntityChest)te;
    }

    private BlockPos choosePosition(World world, RayTraceResult target) {
        BlockPos offset;
        IBlockState state = world.func_180495_p(target.func_178782_a());
        if (state.func_177230_c() == Blocks.field_150486_ae) {
            return target.func_178782_a();
        }
        if (!state.func_177230_c().func_176200_f((IBlockAccess)world, target.func_178782_a()) && (state = world.func_180495_p(offset = target.func_178782_a().func_177972_a(target.field_178784_b))).func_177230_c().func_176200_f((IBlockAccess)world, offset)) {
            return offset;
        }
        return target.func_178782_a();
    }

    @Override
    public List<String> getCompletions(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        switch (args.length) {
            case 1: {
                return CommandBase.func_175762_a((String[])args, Arrays.asList("chest", "entity"));
            }
            case 2: {
                return Subcommand.suggestTableIds(args[1]);
            }
            case 3: {
                if (!args[0].equals("entity")) break;
                return CommandBase.func_175762_a((String[])args, (Collection)EntityList.func_180124_b());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public int getMaxArguments() {
        return 3;
    }
}

