/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import java.util.HashSet;
import leviathan143.loottweaker.common.lib.LootNameFixer;
import leviathan143.loottweaker.common.mixin.LootPoolAccessors;
import leviathan143.loottweaker.common.mixin.LootTableAccessors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;

public class LootFixer {
    public static LootTable fixTable(LootTable table, ResourceLocation tableId) {
        LootNameFixer nameFixer = new LootNameFixer(tableId);
        HashSet<String> usedNames = new HashSet<String>();
        for (LootPool pool : ((LootTableAccessors)table).getPools()) {
            if (!usedNames.add(pool.getName())) {
                nameFixer.deduplicatePoolName(pool);
            }
            LootFixer.fixPool(pool, nameFixer);
        }
        return table;
    }

    private static void fixPool(LootPool pool, LootNameFixer nameFixer) {
        HashSet<String> usedNames = new HashSet<String>();
        if (pool.getName().startsWith("custom#")) {
            nameFixer.fixCustomPoolName((LootPoolAccessors)pool);
        }
        for (LootEntry entry : ((LootPoolAccessors)pool).getEntries()) {
            if (!usedNames.add(entry.getEntryName())) {
                nameFixer.deduplicateEntryName(pool.getName(), entry);
                continue;
            }
            if (!entry.getEntryName().startsWith("custom#")) continue;
            nameFixer.fixCustomEntryName(entry);
        }
    }
}

