/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import leviathan143.loottweaker.common.mixin.LootEntryAccessors;
import leviathan143.loottweaker.common.mixin.LootPoolAccessors;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootNameFixer {
    private static final Logger SANITY_LOGGER = LogManager.getLogger((String)"loottweaker.sanity_checks");
    private final ResourceLocation tableId;
    private int poolDiscriminator = 0;
    private int entryDiscriminator = 0;

    public LootNameFixer(ResourceLocation tableId) {
        this.tableId = tableId;
    }

    public void deduplicatePoolName(LootPool pool) {
        String newName = pool.getName() + this.poolDiscriminator;
        LootNameFixer.logOrThrow(newName, "Duplicate pool name '%s' in table '%s'", pool.getName(), this.tableId);
        ((LootPoolAccessors)pool).setName(newName);
    }

    public void fixCustomPoolName(LootPoolAccessors pool) {
        String poolName = "loottweaker_fixed_pool_" + this.poolDiscriminator;
        SANITY_LOGGER.error("Pool with custom flag found in non-custom table '{}'. Renamed to '{}'.\nReport this to the loot adder.", (Object)this.tableId, (Object)poolName);
        pool.setName(poolName);
    }

    public void deduplicateEntryName(String poolName, LootEntry entry) {
        String newName = entry.getEntryName() + this.entryDiscriminator;
        LootNameFixer.logOrThrow(newName, "Duplicate entry name '%s' in pool '%s' of table '{}'", entry.getEntryName(), poolName, this.tableId);
        ((LootEntryAccessors)entry).setName(newName);
    }

    public void fixCustomEntryName(LootEntry entry) {
        String newName = "loottweaker_fixed_entry_" + this.entryDiscriminator;
        SANITY_LOGGER.error("Entry with custom flag found in non-custom table '{}'. Renamed to '{}'.\nReport this to the loot adder.", (Object)this.tableId, (Object)newName);
        ((LootEntryAccessors)entry).setName(newName);
    }

    public static void ignoreManualPool(String poolName) {
        if (!SANITY_LOGGER.isDebugEnabled()) {
            return;
        }
        SANITY_LOGGER.debug("Ignored pool {} manually created by\n{}", (Object)poolName, (Object)LootNameFixer.getFriendlyStacktrace(4));
    }

    public static void ignoreManualTable() {
        if (!SANITY_LOGGER.isDebugEnabled()) {
            return;
        }
        SANITY_LOGGER.debug("Ignored table manually created by\n{}", (Object)LootNameFixer.getFriendlyStacktrace(4));
    }

    private static StringBuilder getFriendlyStacktrace(int skip) {
        Object[] stackTrace = new Throwable().getStackTrace();
        stackTrace = (StackTraceElement[])ArrayUtils.subarray((Object[])stackTrace, (int)skip, (int)stackTrace.length);
        StringBuilder printedStackTrace = new StringBuilder();
        for (Object element : stackTrace) {
            printedStackTrace.append('\t').append(element).append('\n');
        }
        return printedStackTrace;
    }

    private static void logOrThrow(String newName, String errorFormat, Object ... errorArgs) {
        String error = String.format(errorFormat, errorArgs);
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            throw new IllegalArgumentException(error);
        }
        SANITY_LOGGER.error("{}. Duplicate added as '{}'.\nReport this to the loot adder.", (Object)error, (Object)newName);
    }
}

