/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Map;
import leviathan143.loottweaker.common.lib.LootFixer;
import leviathan143.loottweaker.common.lib.RobustLootConditionSerialiser;
import leviathan143.loottweaker.common.lib.RobustLootEntrySerialiser;
import leviathan143.loottweaker.common.lib.RobustLootFunctionSerialiser;
import leviathan143.loottweaker.common.lib.RobustLootPoolSerialiser;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableDumper {
    private static final Gson ROBUST_GSON = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new RobustLootPoolSerialiser()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new RobustLootEntrySerialiser()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new RobustLootFunctionSerialiser()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new RobustLootConditionSerialiser()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    public static final LootTableDumper DEFAULT = new LootTableDumper(new File("dumps/loot_tables"), ROBUST_GSON);
    private static final Logger LOGGER = LogManager.getLogger();
    private final File dumpFolder;
    private final Gson gsonInstance;

    public LootTableDumper(File dumpFolder, Gson gsonInstance) {
        assert (dumpFolder.isDirectory()) : "Dump folder must be a directory";
        this.dumpFolder = dumpFolder;
        this.dumpFolder.mkdirs();
        this.gsonInstance = gsonInstance;
    }

    public static LootTableDumper robust(File dumpFolder) {
        return new LootTableDumper(dumpFolder, ROBUST_GSON);
    }

    public File getFolder() {
        return this.dumpFolder;
    }

    public File dump(World world, ResourceLocation tableId) {
        return this.dump(world.func_184146_ak().func_186521_a(tableId), tableId);
    }

    public File dump(LootTable lootTable, ResourceLocation tableId) {
        Preconditions.checkNotNull((Object)lootTable);
        lootTable = LootFixer.fixTable(lootTable, tableId);
        File dump = new File(this.dumpFolder, tableId.func_110624_b() + '/' + tableId.func_110623_a() + ".json");
        try {
            dump.getParentFile().mkdirs();
            dump.createNewFile();
            try (FileWriter writer = new FileWriter(dump);){
                JsonWriter dumper = this.gsonInstance.newJsonWriter((Writer)writer);
                dumper.setIndent("  ");
                JsonObject json = (JsonObject)this.gsonInstance.toJsonTree((Object)lootTable);
                json = this.withInfo(json, lootTable, tableId);
                this.gsonInstance.toJson((JsonElement)json, dumper);
            }
            LOGGER.info("Loot table {} saved to {}", (Object)tableId, (Object)dump.getCanonicalPath());
            return dump;
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to dump loot table {}", (Object)tableId, (Object)t);
            return null;
        }
    }

    private JsonObject withInfo(JsonObject old, LootTable lootTable, ResourceLocation tableId) {
        JsonObject info = new JsonObject();
        info.addProperty("id", tableId.toString());
        JsonObject json = new JsonObject();
        json.add("loottweaker:dump_info", (JsonElement)info);
        for (Map.Entry entry : old.entrySet()) {
            json.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return json;
    }
}

