/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.mutable_loot.entry;

import com.google.common.collect.Lists;
import java.util.List;
import leviathan143.loottweaker.common.lib.LootConditions;
import leviathan143.loottweaker.common.mixin.LootEntryAccessors;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public abstract class AbstractMutableLootEntry
implements MutableLootEntry {
    private String name;
    private int weight;
    private int quality;
    private List<LootCondition> conditions;

    protected AbstractMutableLootEntry(LootEntry entry) {
        this.name = entry.getEntryName();
        this.weight = ((LootEntryAccessors)entry).getWeight();
        this.quality = ((LootEntryAccessors)entry).getQuality();
        this.conditions = Lists.newArrayList((Object[])LootConditions.get(entry));
    }

    protected AbstractMutableLootEntry(String name, int weight, int quality, LootCondition[] conditions) {
        this(name, weight, quality, Lists.newArrayList((Object[])conditions));
    }

    protected AbstractMutableLootEntry(String name, int weight, int quality, List<LootCondition> conditions) {
        this.name = name;
        this.weight = weight;
        this.quality = quality;
        this.conditions = conditions;
    }

    @Override
    public abstract MutableLootEntry deepClone();

    @Override
    public abstract LootEntry toImmutable();

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public int getQuality() {
        return this.quality;
    }

    @Override
    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Override
    public List<LootCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(List<LootCondition> conditions) {
        this.conditions = conditions;
    }

    @Override
    public void addCondition(LootCondition condition) {
        this.conditions.add(condition);
    }

    @Override
    public void clearConditions() {
        this.conditions.clear();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

