/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.mutable_loot.entry;

import java.util.Arrays;
import java.util.List;
import leviathan143.loottweaker.common.lib.LootConditions;
import leviathan143.loottweaker.common.mixin.LootEntryAccessors;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import org.apache.commons.lang3.ArrayUtils;

public class GenericMutableLootEntry
implements MutableLootEntry {
    private final LootEntry entry;

    GenericMutableLootEntry(LootEntry entry) {
        this.entry = entry;
    }

    @Override
    public MutableLootEntry deepClone() {
        throw new UnsupportedOperationException(String.format("Could not deep copy entry '%s' as it is a non-vanilla loot entry type (%s)", this.getName(), this.entry.getClass().getName()));
    }

    @Override
    public LootEntry toImmutable() {
        return this.entry;
    }

    @Override
    public int getWeight() {
        return ((LootEntryAccessors)this.entry).getWeight();
    }

    @Override
    public void setWeight(int weight) {
        ((LootEntryAccessors)this.entry).setWeight(weight);
    }

    @Override
    public int getQuality() {
        return ((LootEntryAccessors)this.entry).getQuality();
    }

    @Override
    public void setQuality(int quality) {
        ((LootEntryAccessors)this.entry).setQuality(quality);
    }

    @Override
    public List<LootCondition> getConditions() {
        return Arrays.asList(LootConditions.get(this.entry));
    }

    @Override
    public void setConditions(List<LootCondition> conditions) {
        ((LootEntryAccessors)this.entry).setConditions(conditions.toArray(LootConditions.NONE));
    }

    @Override
    public void addCondition(LootCondition condition) {
        ((LootEntryAccessors)this.entry).setConditions((LootCondition[])ArrayUtils.add((Object[])LootConditions.get(this.entry), (Object)condition));
    }

    @Override
    public void clearConditions() {
        ((LootEntryAccessors)this.entry).setConditions(new LootCondition[0]);
    }

    @Override
    public String getName() {
        return this.entry.getEntryName();
    }

    @Override
    public void setName(String name) {
        ((LootEntryAccessors)this.entry).setName(name);
    }
}

