/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.vmfixes.compat.tombmanygraves;

import com.m4thg33k.tombmanygraves.network.BaseThreadsafePacket;
import com.m4thg33k.tombmanygraves.util.LogHelper;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import io.netty.buffer.ByteBuf;
import mod.acgaming.vmfixes.VMFixes;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.BlockPos;

public class RemoveDeathpointPacket
extends BaseThreadsafePacket {
    private BlockPos pos;

    public RemoveDeathpointPacket() {
    }

    public RemoveDeathpointPacket(BlockPos pos) {
        this.pos = pos;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        IWaypointManager waypointManager = VoxelMap.getInstance().getWaypointManager();
        Waypoint toDel = null;
        for (Waypoint pt : waypointManager.getWaypoints()) {
            if (!pt.name.equals("Latest Death") && !pt.name.contains("Previous Death") || pt.getX() != this.pos.func_177958_n() || pt.getZ() != this.pos.func_177952_p()) continue;
            toDel = pt;
            break;
        }
        if (toDel != null) {
            waypointManager.deleteWaypoint(toDel);
            VMFixes.LOGGER.info("Grave at {} retrieved, deathpoint '{}' deleted", (Object)this.pos, (Object)toDel.name);
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        LogHelper.error((Object)"Attempting to handle remove deathpoint packet on server!");
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
    }
}

