/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.vmfixes.mixin;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ColorManager.class})
public abstract class ColorManagerMixin {
    @Shadow(remap=false)
    Minecraft game;

    @Inject(method={"createTintTable"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void vmfCreateTintTable(IBlockState blockState, MutableBlockPos loopBlockPos, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"tintFromFakePlacedBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void vmfTintFromFakePlacedBlock(IBlockState blockState, MutableBlockPos loopBlockPos, byte biomeID, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)-1);
    }

    @Inject(method={"loadTexturePackTerrainImage"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void vmfLoadTexturePackTerrainImage(CallbackInfo ci) {
        ci.cancel();
    }

    @Overwrite(remap=false)
    public final BufferedImage getBlockImage(IBlockState blockState, ItemStack stack, World world) {
        BufferedImage blockImage = null;
        try {
            if (GLUtils.fboEnabled) {
                IBakedModel model = this.game.func_175599_af().func_184393_a(stack, world, null);
                this.drawModel(1.0f, 2, EnumFacing.EAST, blockState, model, stack);
                blockImage = ImageUtils.createBufferedImageFromGLID((int)GLUtils.fboTextureID);
                blockImage = ImageUtils.trimCentered((BufferedImage)blockImage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blockImage;
    }

    @Shadow(remap=false)
    protected abstract int getColorForTerrainSprite(IBlockState var1, BlockRendererDispatcher var2);

    @Shadow(remap=false)
    protected abstract void drawModel(float var1, int var2, EnumFacing var3, IBlockState var4, IBakedModel var5, ItemStack var6);

    @Overwrite(remap=false)
    private int getColorForBlockPosBlockStateAndFacing(BlockPos blockPos, IBlockState blockState, EnumFacing facing) {
        TextureAtlasSprite icon = null;
        try {
            List quads;
            EnumBlockRenderType blockRenderType = blockState.func_185901_i();
            BlockRendererDispatcher blockRendererDispatcher = this.game.func_175602_ab();
            if (blockRenderType == EnumBlockRenderType.LIQUID) {
                return this.getColorForTerrainSprite(blockState, blockRendererDispatcher);
            }
            if (!blockState.func_177230_c().hasTileEntity(blockState) && !(quads = blockRendererDispatcher.func_184389_a(blockState = blockState.func_185899_b((IBlockAccess)this.game.field_71441_e, blockPos)).func_188616_a(blockState, facing, 0L)).isEmpty()) {
                return this.getColorForIcon(((BakedQuad)quads.get(0)).func_187508_a());
            }
            icon = blockRendererDispatcher.func_175023_a().func_178122_a(blockState);
        }
        catch (Exception blockRenderType) {
            // empty catch block
        }
        if (icon == null || icon.func_94215_i().equals("missingno")) {
            MapColor mapColor = blockState.func_185904_a().func_151565_r();
            int index = mapColor.field_76290_q;
            return mapColor.func_151643_b(index);
        }
        return this.getColorForIcon(icon);
    }

    @Overwrite(remap=false)
    private int getColorForIcon(TextureAtlasSprite icon) {
        int color = 0;
        try {
            BufferedImage iconBuff = this.vmfixes$getBufferedImage(icon);
            if (iconBuff == null) {
                return color;
            }
            Image singlePixel = iconBuff.getScaledInstance(1, 1, 4);
            BufferedImage singlePixelBuff = new BufferedImage(1, 1, iconBuff.getType());
            Graphics2D gfx = singlePixelBuff.createGraphics();
            gfx.drawImage(singlePixel, 0, 0, null);
            gfx.dispose();
            color = singlePixelBuff.getRGB(0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (color == 0x1B000000) {
            color = 0;
        }
        return color;
    }

    @Unique
    private BufferedImage vmfixes$getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }
}

