/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.handlers;

import java.util.Optional;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.api.lib.IDyeableItem;
import pl.asie.charset.api.lib.IWashableItem;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.utils.ItemUtils;

public class DyeableItemWashHandler {
    @SubscribeEvent
    public void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && !event.getEntityPlayer().func_70093_af()) {
            boolean removed = false;
            ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
            if (stack.func_190926_b()) {
                return;
            }
            if (stack.hasCapability(Capabilities.DYEABLE_ITEM, null)) {
                IBlockState state = event.getWorld().func_180495_p(event.getPos());
                IDyeableItem item = (IDyeableItem)stack.getCapability(Capabilities.DYEABLE_ITEM, null);
                if (item != null && state.func_177230_c() instanceof BlockCauldron && state.func_177227_a().contains(BlockCauldron.field_176591_a)) {
                    event.setCanceled(true);
                    int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
                    if (level > 0) {
                        for (int i = 0; i < item.getColorSlotCount(); ++i) {
                            if (!item.hasColor(i) || !item.removeColor(i)) continue;
                            removed = true;
                        }
                    }
                    if (removed) {
                        event.getWorld().func_175656_a(event.getPos(), state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(level - 1)));
                        event.getEntityPlayer().func_71029_a(StatList.field_188079_M);
                    }
                }
            } else if (stack.hasCapability(Capabilities.WASHABLE_ITEM, null)) {
                int level;
                IBlockState state = event.getWorld().func_180495_p(event.getPos());
                IWashableItem item = (IWashableItem)stack.getCapability(Capabilities.WASHABLE_ITEM, null);
                if (item != null && state.func_177230_c() instanceof BlockCauldron && state.func_177227_a().contains(BlockCauldron.field_176591_a) && (level = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) > 0) {
                    event.setCanceled(true);
                    Optional<ItemStack> result = item.wash(stack);
                    if (result.isPresent()) {
                        ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
                        if (ItemUtils.canMerge(held, result.get()) && held.func_190916_E() + result.get().func_190916_E() <= result.get().func_77976_d()) {
                            result.get().func_190917_f(held.func_190916_E());
                            event.getEntityPlayer().func_184611_a(event.getHand(), result.get());
                        } else {
                            ItemUtils.giveOrSpawnItemEntity(event.getEntityPlayer(), event.getWorld(), new Vec3d((Vec3i)event.getPos()).func_72441_c(0.5, 1.0, 0.5), result.get(), 0.0f, 0.0f, 0.0f, 0.0f, true);
                        }
                        event.getWorld().func_175656_a(event.getPos(), state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(level - 1)));
                        event.getEntityPlayer().func_71029_a(StatList.field_188079_M);
                    }
                }
            }
        }
    }
}

