/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.network;

import io.netty.channel.ChannelHandler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumMap;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketChannelHandler;

public class PacketRegistry {
    private static final HashSet<String> usedChannelNames = new HashSet();
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private Class<? extends Packet>[] idPacketMap = new Class[256];
    private Object2IntMap<Class<? extends Packet>> packetIdMap = new Object2IntOpenHashMap();

    public PacketRegistry(String channelName) {
        if (channelName.length() > 20) {
            String trunc = channelName.substring(0, 20);
            ModCharset.logger.warn("Channel name too long: " + channelName + ", truncating to " + trunc);
            channelName = trunc;
        }
        if (usedChannelNames.contains(channelName)) {
            throw new RuntimeException("Channel name already used: " + channelName);
        }
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{new PacketChannelHandler(this)});
        usedChannelNames.add(channelName);
    }

    public void registerPacket(int id, Class<? extends Packet> packet) {
        try {
            packet.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No empty constructor defined! This is a Charset bug!", e);
        }
        this.idPacketMap[id] = packet;
        this.packetIdMap.put(packet, id);
    }

    public net.minecraft.network.Packet getPacketFrom(Packet message) {
        return this.channels.get(Side.SERVER).generatePacketFrom((Object)message);
    }

    public void sendToAll(Packet message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToWatching(Packet message, World world, BlockPos pos, Entity except) {
        if (!(world instanceof WorldServer)) {
            throw new RuntimeException("Attempted to send S->C packet " + message.getClass().getName() + " without a server-side world instance (" + world.getClass().getName() + "); this is a bug!");
        }
        WorldServer worldServer = (WorldServer)world;
        PlayerChunkMap map = worldServer.func_184164_w();
        for (EntityPlayer player : worldServer.field_73010_i) {
            if (player == except || !map.func_72694_a((EntityPlayerMP)player, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)) continue;
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
        }
    }

    public void sendToWatching(Packet message, TileEntity tile) {
        this.sendToWatching(message, tile.func_145831_w(), tile.func_174877_v(), null);
    }

    public void sendToWatching(Packet message, Entity entity) {
        this.sendToWatching(message, entity.func_130014_f_(), entity.func_180425_c(), null);
    }

    public void sendToWatching(Packet message, TileEntity tile, Entity except) {
        this.sendToWatching(message, tile.func_145831_w(), tile.func_174877_v(), except);
    }

    public void sendToWatching(Packet message, Entity entity, Entity except) {
        this.sendToWatching(message, entity.func_130014_f_(), entity.func_180425_c(), except);
    }

    public void sendTo(Packet message, EntityPlayer player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(Packet message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToDimension(Packet message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeOutbound(new Object[]{message});
    }

    public void sendToServer(Packet message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeOutbound(new Object[]{message});
    }

    public void sendToAllAround(Packet packet, TileEntity entity, double d) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.func_145831_w().field_73011_w.getDimension(), (double)entity.func_174877_v().func_177958_n(), (double)entity.func_174877_v().func_177956_o(), (double)entity.func_174877_v().func_177952_p(), d));
    }

    public void sendToAllAround(Packet packet, Entity entity, double d) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, d));
    }

    public Packet instantiatePacket(int i) {
        try {
            return this.idPacketMap[i].newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getPacketId(Class<? extends Packet> aClass) {
        return (Integer)this.packetIdMap.get(aClass);
    }
}

