/*
 * Decompiled with CFR 0.152.
 */
package net.eve0415.ifpatcher.patch;

import java.util.ListIterator;
import net.eve0415.ifpatcher.IFPatcher;
import net.eve0415.ifpatcher.Patch;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PatchPotionBrewer
extends Patch {
    public PatchPotionBrewer(byte[] inputClass) {
        super(inputClass);
    }

    public static IItemHandler patchIngredientItemsHandler(final LockableItemHandler inputIngredients) {
        return new ColoredItemHandler((IItemHandler)inputIngredients, EnumDyeColor.GREEN, "Ingredients items", new BoundingRectangle(82, 25, 90, 18)){

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                if (inputIngredients.getLocked()) {
                    return super.canInsertItem(slot, stack);
                }
                return !stack.func_77973_b().equals(Items.field_151069_bo);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        };
    }

    @Override
    protected boolean patch() {
        AbstractInsnNode insertionPoint = null;
        InsnList initInputInventories = this.findMethod((String)"initInputInventories").instructions;
        ListIterator it = initInputInventories.iterator();
        block0: while (it.hasNext()) {
            AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
            if (!(insnNode instanceof FieldInsnNode) || !((FieldInsnNode)insnNode).name.equals("inputIngredients")) continue;
            it.next();
            while (it.hasNext()) {
                AbstractInsnNode insn = (AbstractInsnNode)it.next();
                if (insn instanceof MethodInsnNode && ((MethodInsnNode)insn).name.equals("addInventory")) {
                    insertionPoint = insn;
                    break block0;
                }
                initInputInventories.remove(insn);
            }
            break block0;
        }
        if (insertionPoint == null) {
            IFPatcher.LOGGER.warn("Could not find target instructions to patch. Skipping.");
            return false;
        }
        InsnList newInst = new InsnList();
        newInst.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInst.add((AbstractInsnNode)new InsnNode(89));
        String hook = "com/buuz135/industrial/tile/magic/PotionEnervatorTile";
        newInst.add((AbstractInsnNode)new FieldInsnNode(180, hook, "inputIngredients", "Lnet/ndrei/teslacorelib/inventory/LockableItemHandler;"));
        newInst.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "patchIngredientItemsHandler", "(Lnet/ndrei/teslacorelib/inventory/LockableItemHandler;)Lnet/minecraftforge/items/IItemHandler;", false));
        initInputInventories.insertBefore(insertionPoint, newInst);
        IFPatcher.LOGGER.info("Potion Brewer can now brew potion that does not start from Nether Wart!");
        return true;
    }
}

