/*
 * Decompiled with CFR 0.152.
 */
package lykrast.jetif;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreIngredient;

public class JETIFWrapper
implements IRecipeWrapper {
    protected List<List<ItemStack>> in;
    protected FluidStack fluid;
    protected ItemStack outItem;
    protected FluidStack outFluid;
    protected String info;

    private JETIFWrapper(FluidStack fluid, String info, ItemStack ... input) {
        this.fluid = fluid;
        this.info = info;
        this.in = new ArrayList<List<ItemStack>>();
        for (ItemStack stack : input) {
            this.in.add(Collections.singletonList(stack));
        }
    }

    public JETIFWrapper(FluidStack fluid, String info, ItemStack out, ItemStack ... input) {
        this(fluid, info, input);
        this.outItem = out;
        this.outFluid = null;
    }

    public JETIFWrapper(FluidStack fluid, String info, FluidStack out, ItemStack ... input) {
        this(fluid, info, input);
        this.outFluid = out;
        this.outItem = ItemStack.field_190927_a;
    }

    public JETIFWrapper(FluidStack fluid, String info, ItemStack out, String input) {
        this.fluid = fluid;
        this.info = info;
        this.in = Collections.singletonList(Arrays.asList(new OreIngredient(input).func_193365_a()));
        this.outItem = out;
        this.outFluid = null;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.FLUID, Collections.singletonList(this.fluid));
        if (this.outFluid != null) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.outFluid);
        }
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.outItem);
        ingredients.setInputLists(VanillaTypes.ITEM, this.in);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.info == null) {
            return;
        }
        String text = I18n.func_135052_a((String)this.info, (Object[])new Object[0]);
        int width = minecraft.field_71466_p.func_78256_a(text);
        int x = (recipeWidth - width) / 2;
        int y = 35;
        minecraft.field_71466_p.func_78276_b(text, x, y, Color.GRAY.getRGB());
    }
}

