/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.cableflux.tiles;

import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltip;
import com.zeitheron.hammercore.tile.tooltip.own.ITooltipProviderHC;
import com.zeitheron.hammercore.utils.base.Cast;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tk.zeitheron.cableflux.blocks.BlockPipe;
import tk.zeitheron.cableflux.pipes.IPipe;
import tk.zeitheron.cableflux.pipes.PipeGrid;
import tk.zeitheron.cableflux.pipes.PipeManager;

public class TilePipe
extends TileSyncableTickable
implements ITooltipProviderHC {
    public BlockPipe block;
    public IPipe pipe;
    boolean tdirty;

    public void neighborChanged() {
        IPipe pipe = this.getPipe();
        if (pipe != null) {
            pipe.neighborChanged();
        }
    }

    public void tick() {
        BlockPipe bp;
        if (this.block == null) {
            bp = (BlockPipe)Cast.cast((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), BlockPipe.class);
            if (bp != null) {
                this.block = bp;
            } else {
                this.field_145850_b.func_175713_t(this.field_174879_c);
                return;
            }
        }
        if (!this.createPipe()) {
            this.field_145850_b.func_175713_t(this.field_174879_c);
            return;
        }
        this.pipe.update(this);
        if (this.pipe.isDead()) {
            bp = (BlockPipe)Cast.cast((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), BlockPipe.class);
            if (bp != null) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
            } else {
                this.pipe.createDrops(this.getLocation());
                this.field_145850_b.func_175713_t(this.field_174879_c);
            }
        }
        if (this.atTickRate(2)) {
            this.setTooltipDirty(true);
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        if (this.createPipe()) {
            this.pipe.write(nbt);
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        if (this.createPipe()) {
            this.pipe.read(nbt);
        }
    }

    private boolean createPipe() {
        if (this.block != null && this.pipe == null) {
            this.pipe = this.block.ptype.get();
            if (this.pipe == null) {
                return false;
            }
            if (this.pipe.getWorld() == null) {
                this.pipe.setWorld(this.readNBT_world != null ? this.readNBT_world : this.field_145850_b);
            }
            if (this.pipe.getCoords() == null) {
                this.pipe.setCoords(this.field_174879_c);
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                IPipe p = PipeManager.getPipe((IBlockAccess)this.field_145850_b, this.field_174879_c.func_177972_a(face));
                if (p == null || !p.canAddToSameGrid(p) || p.getGrid() == null) continue;
                p.getGrid().addPipe(this.pipe);
                p.neighborChanged();
            }
            if (this.pipe.getGrid() == null) {
                PipeGrid.defineGrid(this.field_145850_b, this.field_174879_c);
            }
            this.neighborChanged();
        }
        return this.pipe != null;
    }

    public IPipe getPipe() {
        this.createPipe();
        return this.pipe;
    }

    public boolean isTooltipDirty() {
        return this.tdirty;
    }

    public void setTooltipDirty(boolean dirty) {
        this.tdirty = dirty;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ITooltip tip) {
        if (this.pipe != null) {
            this.pipe.hookTooltip(tip);
        }
    }
}

