/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.method;

import dan200.computercraft.api.lua.LuaException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ArgumentHelper {
    private ArgumentHelper() {
    }

    @Nonnull
    public static LuaException badObjectType(@Nonnull String key, @Nonnull String expected, @Nullable Object object) {
        return ArgumentHelper.badObject(key, expected, dan200.computercraft.core.apis.ArgumentHelper.getType((Object)object));
    }

    @Nonnull
    public static LuaException badObject(@Nonnull String key, @Nonnull String expected, @Nonnull String type) {
        return new LuaException("bad key '" + key + "' (" + expected + " expected, got " + type + ")");
    }

    public static float getFloat(@Nonnull Object[] args, int index) throws LuaException {
        return (float)dan200.computercraft.core.apis.ArgumentHelper.getReal((Object[])args, (int)index);
    }

    @Nonnull
    public static <T extends Enum<T>> T getEnum(@Nonnull Object[] args, int index, Class<T> klass) throws LuaException {
        if (index >= args.length) {
            throw dan200.computercraft.core.apis.ArgumentHelper.badArgument((int)index, (String)"string", (String)"no value");
        }
        Object value = args[index];
        if (value instanceof String) {
            String name = (String)value;
            try {
                return Enum.valueOf(klass, name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new LuaException("Bad name '" + name.toLowerCase(Locale.ENGLISH) + "' for argument " + (index + 1));
            }
        }
        throw dan200.computercraft.core.apis.ArgumentHelper.badArgument((int)index, (String)"string", (Object)value);
    }

    public static float optFloat(@Nonnull Object[] args, int index, float def) throws LuaException {
        Object value;
        Object object = value = index < args.length ? args[index] : null;
        if (value == null) {
            return def;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        throw dan200.computercraft.core.apis.ArgumentHelper.badArgument((int)index, (String)"number", (Object)value);
    }

    @Nonnull
    public static <T extends Enum<T>> T optEnum(@Nonnull Object[] args, int index, Class<T> klass, T def) throws LuaException {
        return index >= args.length || args[index] == null ? def : ArgumentHelper.getEnum(args, index, klass);
    }

    public static void assertBetween(double value, double min, double max, String message) throws LuaException {
        if (value < min || value > max || Double.isNaN(value)) {
            throw new LuaException(String.format(message, "between " + min + " and " + max));
        }
    }

    public static void assertBetween(int value, int min, int max, String message) throws LuaException {
        if (value < min || value > max) {
            throw new LuaException(String.format(message, "between " + min + " and " + max));
        }
    }

    public static String numberType(double value) {
        if (Double.isNaN(value)) {
            return "nan";
        }
        if (value == Double.POSITIVE_INFINITY) {
            return "inf";
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        return "number";
    }
}

