/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.docdump;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.squiddev.plethora.api.WorldLocation;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.module.BasicModuleContainer;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.core.PartialContext;
import org.squiddev.plethora.core.capabilities.EmptyCostHandler;
import org.squiddev.plethora.core.collections.ClassIteratorIterable;
import org.squiddev.plethora.core.collections.SortedMultimap;
import org.squiddev.plethora.core.docdump.DocumentedItem;
import org.squiddev.plethora.core.docdump.DocumentedMetaProvider;
import org.squiddev.plethora.core.docdump.DocumentedMethod;
import org.squiddev.plethora.core.docdump.IDocWriter;
import org.squiddev.plethora.core.docdump.ObjectWriter;
import org.squiddev.plethora.utils.WorldDummy;

public class HTMLWriter
implements IDocWriter {
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.#######");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss yyyy-MM-dd");
    private final PrintStream writer;
    private final ObjectWriter objectWriter;
    private final Map<String, Object> escapeMap = new HashMap<String, Object>();
    private final ListMultimap<String, DocumentedMethod> methodLookup = MultimapBuilder.treeKeys().arrayListValues().build();
    private final ListMultimap<String, DocumentedMethod> moduleMethodLookup = MultimapBuilder.treeKeys().arrayListValues().build();
    private final ListMultimap<String, DocumentedMetaProvider> metaLookup = MultimapBuilder.treeKeys().arrayListValues().build();

    public HTMLWriter(OutputStream stream, Multimap<Class<?>, IMethod<?>> methodLookup, SortedMultimap<Class<?>, IMetaProvider<?>> metaProviders) {
        PrintStream writer;
        try {
            writer = new PrintStream(stream, false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            writer = new PrintStream(stream);
        }
        this.writer = writer;
        this.objectWriter = new HtmlObjectWriter(writer);
        for (Map.Entry entry : methodLookup.entries()) {
            IMethod method = (IMethod)entry.getValue();
            DocumentedMethod data = new DocumentedMethod((Class)entry.getKey(), method);
            if (data.getModules().isEmpty() || !data.getTarget().isAssignableFrom(IModuleContainer.class)) {
                this.methodLookup.put((Object)data.getTarget().getName(), (Object)data);
                continue;
            }
            this.moduleMethodLookup.put((Object)Strings.join(data.getModules(), (String)", "), (Object)data);
        }
        for (Map.Entry entry : metaProviders.items().entrySet()) {
            String klass = ((Class)entry.getKey()).getName();
            for (IMetaProvider provider : (Collection)entry.getValue()) {
                this.metaLookup.put((Object)klass, (Object)new DocumentedMetaProvider((Class)entry.getKey(), provider));
            }
        }
    }

    @Override
    public void writeHeader() throws IOException {
        try (InputStream header = this.getClass().getClassLoader().getResourceAsStream("assets/plethora/header.html");){
            if (header == null) {
                this.writer.println("<html><body>");
            } else {
                ByteStreams.copy((InputStream)header, (OutputStream)this.writer);
            }
        }
    }

    @Override
    public void writeFooter() throws IOException {
        this.writer.printf("<footer>Generated on %s</footer>\n", DATE_FORMAT.format(new Date()));
        try (InputStream footer = this.getClass().getClassLoader().getResourceAsStream("assets/plethora/footer.html");){
            if (footer == null) {
                this.writer.println("</body></html>");
            } else {
                ByteStreams.copy((InputStream)footer, (OutputStream)this.writer);
            }
        }
    }

    @Override
    public void write() throws IOException {
        if (!this.moduleMethodLookup.isEmpty()) {
            this.writeGroupHeader("Module methods", this.moduleMethodLookup);
        }
        if (!this.methodLookup.isEmpty()) {
            this.writeGroupHeader("Targeted methods", this.methodLookup);
        }
        if (!this.metaLookup.isEmpty()) {
            this.writeGroupHeader("Metadata providers", this.metaLookup);
        }
        if (!this.moduleMethodLookup.isEmpty()) {
            this.writeGroupElements("Module methods", this.moduleMethodLookup, this::writeMethodTarget);
        }
        if (!this.methodLookup.isEmpty()) {
            this.writeGroupElements("Targeted methods", this.methodLookup, this::writeMethodTarget);
        }
        if (!this.metaLookup.isEmpty()) {
            this.writeGroupElements("Metadata providers", this.metaLookup, this::writeMetaTarget);
        }
    }

    private <T extends DocumentedItem<?>> void writeGroupHeader(String title, ListMultimap<String, T> lookup) {
        String groupId = HTMLWriter.ident(title.toLowerCase());
        this.writer.printf("<h2 class=\"group-name\">%s</h2>\n", title);
        this.writer.println("<ul>");
        for (String target : lookup.keySet()) {
            this.writer.printf("<li>%s</li>\n", HTMLWriter.linkToTarget(groupId, target));
        }
        this.writer.println("</ul>");
    }

    private <T extends DocumentedItem<?>> void writeGroupElements(String title, ListMultimap<String, T> lookup, DocEmitter<List<T>> emitter) throws IOException {
        String groupId = HTMLWriter.ident(title.toLowerCase());
        this.writer.printf("<h2 id=\"%s\" class=\"group-name\">%s</h2>\n", groupId, title);
        this.writer.println("<div class=\"group-data\">");
        for (String target : lookup.keySet()) {
            emitter.emit(groupId, target, lookup.get((Object)target));
        }
        this.writer.println("</div>");
    }

    private void writeMethodTarget(String group, String target, List<DocumentedMethod> docs) {
        this.writer.printf("<h3 id=\"%s-%s\" class=\"target-name\" >%s</h3>\n", group, HTMLWriter.ident(target), target);
        this.writer.println("<div class=\"target-data\">");
        this.writer.println("<table class=\"doc-list\">");
        this.writer.println("<tr><th>Function</th><th>Synopsis</th></tr>");
        Collections.sort(docs);
        for (DocumentedMethod doc : docs) {
            this.writer.printf("<tr><td>%s<td>%s</td></tr>\n", this.linkToItem(doc), HTMLWriter.empty(doc.getSynopsis()));
        }
        this.writer.println("</table>");
        for (DocumentedMethod data : docs) {
            this.writeMethod(data);
        }
        this.writer.println("</div>");
    }

    private void writeMethod(DocumentedMethod doc) {
        this.writer.println("<div class=\"doc-item\">");
        this.writer.printf("<h4 id=\"%s\" class=\"doc-name\">%s</h4>\n", this.uniqueIdent(doc), doc.getFriendlyName() + doc.getArgs());
        if (doc.getSynopsis() != null) {
            this.writer.printf("<p class=\"synopsis\">%s</p>\n", doc.getSynopsis());
        }
        if (doc.getDetail() != null) {
            this.writer.printf("<p>%s</p>\n", doc.getDetail().replace("\n", "</p>\n<p>"));
        }
        this.writer.println("<table class=\"doc-details\">");
        this.writer.printf("<tr><td>Class</td><td><code>%s</code></td></tr>\n", doc.getId());
        this.writer.printf("<tr><td>Target</td><td><code>%s</code></td></tr>\n", doc.getTarget().getName());
        if (doc.getSubtarget() != null) {
            this.writer.printf("<tr><td>Sub-target</td><td><code>%s</code></td></tr>\n", doc.getSubtarget().getName());
        }
        if (!doc.getModules().isEmpty()) {
            this.writer.print("<tr><td>Modules</td><td>");
            for (String module : doc.getModules()) {
                this.writer.printf("<code>%s</code> ", module);
            }
            this.writer.print("</td></tr>\n");
        }
        this.writer.println("</table>");
        this.writer.println("</div>");
    }

    private void writeMetaTarget(String group, String target, List<DocumentedMetaProvider> docs) throws IOException {
        this.writer.printf("<h3 id=\"%s-%s\" class=\"target-name\" >%s</h3>\n", group, HTMLWriter.ident(target), target);
        this.writer.println("<div class=\"target-data\">");
        Class<?> targetClass = docs.get(0).getTarget();
        ArrayList<String> parents = new ArrayList<String>();
        for (Class<?> superclass : new ClassIteratorIterable(targetClass)) {
            if (superclass == targetClass || this.metaLookup.get((Object)superclass.getName()).isEmpty()) continue;
            parents.add(superclass.getName());
        }
        if (!parents.isEmpty()) {
            parents.sort(Comparator.comparing(HTMLWriter::shortName));
            this.writer.print("<p>Also includes metadata from ");
            for (int i = 0; i < parents.size(); ++i) {
                if (i > 0) {
                    this.writer.print(", ");
                }
                this.writer.print(HTMLWriter.linkToShortTarget(group, (String)parents.get(i)));
            }
            this.writer.print("</p>");
        }
        for (DocumentedMetaProvider doc : docs) {
            this.writeMeta(doc);
        }
        this.writer.println("</div>");
    }

    private void writeMeta(DocumentedMetaProvider doc) throws IOException {
        Map<String, ?> meta;
        IMetaProvider provider;
        Object example;
        this.writer.println("<div class=\"doc-item\">");
        this.writer.printf("<h4 id=\"%s\" class=\"doc-name\">%s</h4>\n", this.uniqueIdent(doc), doc.getFriendlyName());
        if (doc.getSynopsis() != null) {
            this.writer.printf("<p class=\"synopsis\">%s</p>\n", doc.getSynopsis());
        }
        if (doc.getDetail() != null) {
            this.writer.printf("<p>%s</p>\n", doc.getDetail().replace("\n", "</p>\n<p>"));
        }
        if ((example = (provider = (IMetaProvider)doc.getObject()).getExample()) != null && !(meta = provider.getMeta(new PartialContext(1, new String[]{"origin", "target"}, new Object[]{new WorldLocation((World)WorldDummy.INSTANCE, BlockPos.field_177992_a), example}, EmptyCostHandler.INSTANCE, BasicModuleContainer.EMPTY))).isEmpty()) {
            this.writer.println("<pre class=\"highlight\">");
            this.objectWriter.write(meta);
            this.writer.println("</pre>");
        }
        this.writer.println("</div>");
    }

    private String uniqueIdent(DocumentedItem<?> data) {
        String name = HTMLWriter.ident(data.getId());
        int id = 0;
        String fullName;
        Object existing;
        while ((existing = this.escapeMap.get(fullName = id == 0 ? name : name + "-" + id)) != data.getObject()) {
            if (existing == null) {
                this.escapeMap.put(fullName, data.getObject());
                return fullName;
            }
            ++id;
        }
        return fullName;
    }

    private String linkToItem(DocumentedItem<?> data) {
        return String.format("<a href=\"#%s\" class=\"doc-name\">%s</a>", this.uniqueIdent(data), data.getFriendlyName());
    }

    private static String linkToTarget(String group, String name) {
        return String.format("<a href=\"#%s-%s\" class=\"target-name\">%s</a>", group, HTMLWriter.ident(name), name);
    }

    private static String linkToShortTarget(String group, String name) {
        return String.format("<a href=\"#%s-%s\" class=\"target-name\">%s</a>", group, HTMLWriter.ident(name), HTMLWriter.shortName(name));
    }

    private static String ident(String value) {
        return value.replaceAll("[^0-9a-zA-Z$-_.+!*'()]+", "-");
    }

    private static String empty(String x) {
        return x == null ? "" : x;
    }

    private static String shortName(String name) {
        int index = name.lastIndexOf(46);
        return index >= 0 ? name.substring(index + 1) : name;
    }

    @Override
    public void close() {
        this.writer.close();
    }

    private static final class HtmlObjectWriter
    extends ObjectWriter {
        HtmlObjectWriter(Appendable stream) {
            super(stream);
        }

        @Override
        public void writeValue(boolean value) throws IOException {
            this.classed("kc", value ? "true" : "false");
        }

        @Override
        public void writeValue(Void value) throws IOException {
            this.classed("kc", "nil");
        }

        @Override
        public void writeValue(String value) throws IOException {
            StringBuilder builder = new StringBuilder(2 + value.length());
            builder.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\n') {
                    builder.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    builder.append("\\t");
                    continue;
                }
                if (c < ' ' || c > '~') {
                    builder.append("\\").append((int)c);
                    continue;
                }
                builder.append(c);
            }
            this.classed("s2", builder.append('\"').toString());
        }

        @Override
        public void writeSpecial(String value) throws IOException {
            this.classed("o", "&laquo;" + value + "&raquo;");
        }

        @Override
        protected void writeValue(Map<?, ?> value, String indent) throws IOException {
            if (value.isEmpty()) {
                this.output.append("{}");
                return;
            }
            this.output.append("<span class=\"meta-map\">").append("<span class=\"meta-brace\">{</span>");
            this.writeMapBody(value, indent);
            this.output.append("<span class=\"meta-brace\">}</span>").append("</span>");
        }

        @Override
        protected void writeMeta(TypedMeta<?, ?> meta, String indent) throws IOException {
            if (meta.isEmpty()) {
                this.output.append("{}");
                return;
            }
            if (indent.isEmpty()) {
                this.writeValue(meta, indent);
                return;
            }
            this.output.append("<span class=\"nested-meta meta-map\">").append("<span class=\"meta-brace\">{</span>");
            this.output.append("<span class=\"nested-meta-short\"> ");
            this.writeSpecial("nested metadata");
            this.output.append(" </span>");
            this.output.append("<span class=\"nested-meta-long\">");
            this.writeMapBody(meta, indent);
            this.output.append("</span>");
            this.output.append("<span class=\"meta-brace\">}</span>").append("</span>");
        }

        private void classed(String css, String value) throws IOException {
            this.output.append(String.format("<span class=\"%s\">%s</span>", css, value));
        }
    }

    @FunctionalInterface
    private static interface DocEmitter<T> {
        public void emit(String var1, String var2, T var3) throws IOException;
    }
}

