/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.squiddev.plethora.gameplay.ConfigGameplay;

public final class ConfigGameplayForgeLoader {
    private static Configuration configuration;

    public static void doSync() {
        Configuration config = configuration;
        ConfigGameplay.Laser.minimumPotency = config.get("laser", "minimumPotency", 0.5, "The minimum power of a laser.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.laser.minimumPotency").getDouble();
        ConfigGameplay.Laser.maximumPotency = config.get("laser", "maximumPotency", 5.0, "The maximum power of a laser.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.laser.maximumPotency").getDouble();
        ConfigGameplay.Laser.cost = config.get("laser", "cost", 10.0, "The energy cost per potency for a laser.\n See Plethora.cfg#CostSystem for more info").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.laser.cost").getDouble();
        ConfigGameplay.Laser.damage = config.get("laser", "damage", 4.0, "The damage done to an entity by a laser per potency.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.laser.damage").getDouble();
        ConfigGameplay.Laser.lifetime = config.get("laser", "lifetime", 100, "The maximum time in ticks a laser can exist for before it'll despawn.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.laser.lifetime").getInt();
        config.getCategory("laser").setLanguageKey("gui.config.plethora.laser").setComment("Config options for the laser module");
        ConfigGameplay.Kinetic.launchMax = config.get("kinetic", "launchMax", 4, "The maximum velocity the kinetic manipulator can apply to you.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.launchMax").getInt();
        ConfigGameplay.Kinetic.launchCost = config.get("kinetic", "launchCost", 0, "The cost per launch power").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.launchCost").getInt();
        ConfigGameplay.Kinetic.launchYScale = config.get("kinetic", "launchYScale", 0.5, "The value to scale the y velocity by, helps limit how high the player can go.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.launchYScale").getDouble();
        ConfigGameplay.Kinetic.launchFallReset = config.get("kinetic", "launchFallReset", true, "Whether to scale the fall distance after launching.\n\n This means the player will not die from fall damage if they launch themselves\n upwards in order to cancel out their negative velocity. This may not work correctly\n with mods which provide custom gravity, such as Galacticraft.").setLanguageKey("gui.config.plethora.kinetic.launchFallReset").getBoolean();
        ConfigGameplay.Kinetic.launchFloatReset = config.get("kinetic", "launchFloatReset", true, "Whether to reset the floating timer after launching.\n\n This means the player will not be kicked for flying after using the kinetic augment a lot.").setLanguageKey("gui.config.plethora.kinetic.launchFloatReset").getBoolean();
        ConfigGameplay.Kinetic.launchElytraScale = config.get("kinetic", "launchElytraScale", 0.4, "The value to scale the velocity by when flying, helps limit how fast the player can go.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.launchElytraScale").getDouble();
        ConfigGameplay.Kinetic.walkRange = config.get("kinetic", "walkRange", 32, "The maximum range that the entity can path find to.").setMinValue(1).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.walkRange").getInt();
        ConfigGameplay.Kinetic.walkSpeed = config.get("kinetic", "walkSpeed", 3, "The maximum speed that the entity can walk at.").setMinValue(1).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.walkSpeed").getInt();
        ConfigGameplay.Kinetic.walkCost = config.get("kinetic", "walkCost", 0, "The cost of walking.\n This is multiplied by the distance and speed walked.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.walkCost").getInt();
        ConfigGameplay.Kinetic.teleportRange = config.get("kinetic", "teleportRange", 32, "The maximum range that endermen can teleport to.").setMinValue(1).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.teleportRange").getInt();
        ConfigGameplay.Kinetic.teleportCost = config.get("kinetic", "teleportCost", 0, "The cost per block teleported").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.teleportCost").getInt();
        ConfigGameplay.Kinetic.shootCost = config.get("kinetic", "shootCost", 20, "The cost to shoot an arrow per potency.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.shootCost").getInt();
        ConfigGameplay.Kinetic.propelMax = config.get("kinetic", "propelMax", 2.0, "The maximum velocity a minecart can be propelled at.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.propelMax").getDouble();
        ConfigGameplay.Kinetic.propelCost = config.get("kinetic", "propelCost", 0.0, "The cost per velocity unit.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.kinetic.propelCost").getDouble();
        config.getCategory("kinetic").setLanguageKey("gui.config.plethora.kinetic");
        ConfigGameplay.Scanner.radius = config.get("scanner", "radius", 8, "The radius scanners can get blocks in.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.scanner.radius").getInt();
        ConfigGameplay.Scanner.maxRadius = config.get("scanner", "maxRadius", 16, "The radius a fully upgraded scanner can get blocks in.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.scanner.maxRadius").getInt();
        ConfigGameplay.Scanner.scanLevelCost = config.get("scanner", "scanLevelCost", 50, "The additional cost each level incurs for scan().").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.scanner.scanLevelCost").getInt();
        config.getCategory("scanner").setLanguageKey("gui.config.plethora.scanner");
        ConfigGameplay.Sensor.radius = config.get("sensor", "radius", 16, "The radius sensors can get entities in.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.sensor.radius").getInt();
        ConfigGameplay.Sensor.maxRadius = config.get("sensor", "maxRadius", 32, "The radius a fully upgraded sensor can get entities in.").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.sensor.maxRadius").getInt();
        ConfigGameplay.Sensor.senseLevelCost = config.get("sensor", "senseLevelCost", 40, "The additional cost each level incurs for sense().").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.sensor.senseLevelCost").getInt();
        config.getCategory("sensor").setLanguageKey("gui.config.plethora.sensor");
        ConfigGameplay.Chat.maxLength = config.get("chat", "maxLength", 100, "The maximum length a chat message can be.\n\n Set to 0 to disable").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.chat.maxLength").getInt();
        ConfigGameplay.Chat.allowBinding = config.get("chat", "allowBinding", true, "Whether binding a chat recorder allows players to send\n and capture messages. You may want to disable this if you\n are experiencing abuse.").setLanguageKey("gui.config.plethora.chat.allowBinding").getBoolean();
        ConfigGameplay.Chat.allowFormatting = config.get("chat", "allowFormatting", false, "Whether formatting codes are allowed in chat messages.").setLanguageKey("gui.config.plethora.chat.allowFormatting").getBoolean();
        ConfigGameplay.Chat.allowOffline = config.get("chat", "allowOffline", true, "Whether offline players are allowed to post chat messages.\n Otherwise this is just limited to those who are online players.").setLanguageKey("gui.config.plethora.chat.allowOffline").getBoolean();
        ConfigGameplay.Chat.allowMobs = config.get("chat", "allowMobs", true, "Whether mobs are allowed to post chat messages.\n Otherwise this is just limited to players.").setLanguageKey("gui.config.plethora.chat.allowMobs").getBoolean();
        config.getCategory("chat").setLanguageKey("gui.config.plethora.chat");
        ConfigGameplay.Glasses.framebufferScale = config.get("glasses", "framebufferScale", 1, "The dimensions with which to scale the framebuffer texture.\n Higher scales result in cleaner renders, with the cost of\n a (potentially) lower framerate.").setMinValue(1).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.glasses.framebufferScale").getInt();
        config.getCategory("glasses").setLanguageKey("gui.config.plethora.glasses");
        ConfigGameplay.Turtle.feFuelRatio = config.get("turtle", "feFuelRatio", 0, "The amount of RF required to gain one unit of turtle fuel.\n Set to 0 to disable (the default). If enabled, a good default\n is 100 (100FE for one fuel unit).").setMinValue(0).setMaxValue(Integer.MAX_VALUE).setLanguageKey("gui.config.plethora.turtle.feFuelRatio").getInt();
        config.getCategory("turtle").setLanguageKey("gui.config.plethora.turtle");
        ConfigGameplay.Miscellaneous.funRender = config.get("miscellaneous", "funRender", true, "Fun rendering overlay for various objects.\n Basically I'm slightly vain.").setLanguageKey("gui.config.plethora.miscellaneous.funRender").getBoolean();
        config.getCategory("miscellaneous").setLanguageKey("gui.config.plethora.miscellaneous").setComment("Various options that don't belong to anything");
    }

    public static void init(File file) {
        configuration = new Configuration(file);
        configuration.load();
        ConfigGameplayForgeLoader.sync();
    }

    public static void init(Configuration config) {
        configuration = config;
        ConfigGameplayForgeLoader.sync();
    }

    public static void sync() {
        ConfigGameplayForgeLoader.doSync();
        configuration.save();
    }

    public static Configuration getConfiguration() {
        return configuration;
    }
}

