/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.keyboard;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.keyboard.KeyMessage;
import org.squiddev.plethora.gameplay.keyboard.ListenMessage;

public final class ServerKeyListener {
    private static final WeakHashMap<EntityPlayerMP, Set<IModuleAccess>> listeners = new WeakHashMap();

    private ServerKeyListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(@Nonnull EntityPlayerMP player, @Nonnull IModuleAccess access) {
        WeakHashMap<EntityPlayerMP, Set<IModuleAccess>> weakHashMap = listeners;
        synchronized (weakHashMap) {
            Set accesses = listeners.computeIfAbsent(player, k -> new HashSet(1));
            if (accesses.isEmpty()) {
                Plethora.network.sendTo((IMessage)new ListenMessage(true), player);
            }
            accesses.add(access);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(@Nonnull EntityPlayerMP player, @Nonnull IModuleAccess access) {
        WeakHashMap<EntityPlayerMP, Set<IModuleAccess>> weakHashMap = listeners;
        synchronized (weakHashMap) {
            Set<IModuleAccess> accesses = listeners.get(player);
            if (accesses == null) {
                return;
            }
            if (accesses.remove(access) && accesses.isEmpty()) {
                Plethora.network.sendTo((IMessage)new ListenMessage(false), player);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        WeakHashMap<EntityPlayerMP, Set<IModuleAccess>> weakHashMap = listeners;
        synchronized (weakHashMap) {
            listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void process(EntityPlayerMP player, List<KeyMessage.KeyPress> presses, List<Integer> releases) {
        WeakHashMap<EntityPlayerMP, Set<IModuleAccess>> weakHashMap = listeners;
        synchronized (weakHashMap) {
            Set<IModuleAccess> accesses = listeners.get(player);
            if (accesses != null && !accesses.isEmpty()) {
                for (IModuleAccess access : accesses) {
                    for (KeyMessage.KeyPress press : presses) {
                        if (press.key > 0) {
                            access.queueEvent("key", press.key, press.repeat);
                        }
                        if (press.ch == '\u0000') continue;
                        access.queueEvent("char", Character.toString(press.ch));
                    }
                    for (Integer up : releases) {
                        access.queueEvent("key_up", up);
                    }
                }
            }
        }
    }
}

