/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;

public interface Colourable {
    public static final int DEFAULT_COLOUR = -1;

    public int getColour();

    public void setColour(int var1);

    @PlethoraMethod(name={"getColour", "getColor"}, doc="-- Get the colour for this object.", worldThread=false)
    public static long getColour(@FromTarget Colourable colourable) {
        int colour = colourable.getColour();
        return (long)colour & 0xFFFFFFFFL;
    }

    @PlethoraMethod(worldThread=false, name={"setColor", "setColour"}, doc="function(colour|r:int, [g:int, b:int], [alpha:int]):number -- Set the colour for this object.")
    public static void setColour(@FromTarget Colourable object, Object[] args) throws LuaException {
        switch (args.length) {
            case 1: {
                object.setColour(ArgumentHelper.getInt((Object[])args, (int)0));
                break;
            }
            case 3: {
                int r = ArgumentHelper.getInt((Object[])args, (int)0) & 0xFF;
                int g = ArgumentHelper.getInt((Object[])args, (int)1) & 0xFF;
                int b = ArgumentHelper.getInt((Object[])args, (int)2) & 0xFF;
                object.setColour(r << 24 | g << 16 | b << 8 | object.getColour() & 0xFF);
                break;
            }
            default: {
                int r = ArgumentHelper.getInt((Object[])args, (int)0) & 0xFF;
                int g = ArgumentHelper.getInt((Object[])args, (int)1) & 0xFF;
                int b = ArgumentHelper.getInt((Object[])args, (int)2) & 0xFF;
                int a = ArgumentHelper.getInt((Object[])args, (int)3) & 0xFF;
                object.setColour(r << 24 | g << 16 | b << 8 | a);
                break;
            }
        }
    }

    @PlethoraMethod(doc="-- Get the alpha for this object.", worldThread=false)
    public static int getAlpha(@FromTarget Colourable colourable) {
        return colourable.getColour() & 0xFF;
    }

    @PlethoraMethod(doc="-- Set the alpha for this object.", worldThread=false)
    public static void setAlpha(@FromTarget Colourable object, int alpha) {
        object.setColour(object.getColour() & 0xFFFFFF00 | alpha & 0xFF);
    }
}

