/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.computercraft;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.ItemStackMetaProvider;

@Injects(value="computercraft")
public final class MetaItemTurtle
extends ItemStackMetaProvider<ITurtleItem> {
    public MetaItemTurtle() {
        super("turtle", ITurtleItem.class);
    }

    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull ItemStack object, @Nonnull ITurtleItem turtle) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        int colour = turtle.getColour(object);
        if (colour != -1) {
            out.put("color", colour);
            out.put("colour", colour);
        }
        out.put("fuel", turtle.getFuelLevel(object));
        out.put("left", MetaItemTurtle.getUpgrade(turtle.getUpgrade(object, TurtleSide.Left)));
        out.put("right", MetaItemTurtle.getUpgrade(turtle.getUpgrade(object, TurtleSide.Right)));
        return out;
    }

    static Map<String, String> getUpgrade(ITurtleUpgrade upgrade) {
        if (upgrade == null) {
            return null;
        }
        HashMap<String, String> out = new HashMap<String, String>(2);
        out.put("id", upgrade.getUpgradeID().toString());
        out.put("adjective", upgrade.getUnlocalisedAdjective());
        out.put("type", upgrade.getType().toString());
        return out;
    }

    @Override
    @Nonnull
    public ItemStack getExample() {
        return TurtleItemFactory.create((int)3, (String)"My turtle", (int)65280, (ComputerFamily)ComputerFamily.Normal, (ITurtleUpgrade)ComputerCraft.TurtleUpgrades.advancedModem, null, (int)3000, null);
    }
}

